import type { BranchStatus } from '../../../types';
import type { Issue, PlatformParams, PlatformResult, Pr, RepoResult } from '../types';
export declare const id = "local";
export declare function initPlatform(params: PlatformParams): Promise<PlatformResult>;
export declare function getRepos(): Promise<string[]>;
export declare function initRepo(): Promise<RepoResult>;
export declare function findIssue(): Promise<null>;
export declare function getIssueList(): Promise<Issue[]>;
export declare function getRawFile(): Promise<string | null>;
export declare function getJsonFile(): Promise<Record<string, unknown> | null>;
export declare function getPrList(): Promise<Pr[]>;
export declare function ensureIssueClosing(): Promise<void>;
export declare function ensureIssue(): Promise<null>;
export declare function massageMarkdown(input: string): string;
/**
 * Unsed, no Dashboard
 */
export declare function maxBodyLength(): number;
export declare function updatePr(): Promise<void>;
export declare function mergePr(): Promise<boolean>;
export declare function addReviewers(): Promise<void>;
export declare function addAssignees(): Promise<void>;
export declare function createPr(): Promise<null>;
export declare function deleteLabel(): Promise<void>;
export declare function setBranchStatus(): Promise<void>;
export declare function getBranchStatus(): Promise<BranchStatus>;
export declare function getBranchStatusCheck(): Promise<null>;
export declare function ensureCommentRemoval(): Promise<void>;
export declare function ensureComment(): Promise<boolean>;
export declare function getPr(): Promise<null>;
export declare function findPr(): Promise<null>;
export declare function getBranchPr(): Promise<null>;
