import type { GitlabHttp } from '../../../util/http/gitlab';
import type { GitlabPr } from './types';
export declare class GitlabPrCache {
    private repo;
    private ignorePrAuthor;
    private items;
    private cache;
    private constructor();
    private static init;
    private getPrs;
    static getPrs(http: GitlabHttp, repo: string, author: string | null, ignorePrAuthor: boolean): Promise<GitlabPr[]>;
    private setPr;
    static setPr(http: GitlabHttp, repo: string, author: string | null, item: GitlabPr, ignorePrAuthor: boolean): Promise<void>;
    private reconcile;
    private sync;
    /**
     * Ensure the pr cache starts with the most recent PRs.
     * JavaScript ensures that the cache is sorted by PR number.
     */
    private updateItems;
}
