import type { BranchStatus } from '../../../types';
import type { AutodiscoverConfig, BranchStatusConfig, CreatePRConfig, EnsureCommentConfig, EnsureCommentRemovalConfig, EnsureIssueConfig, FindPRConfig, Issue, MergePRConfig, PlatformParams, PlatformResult, Pr, ReattemptPlatformAutomergeConfig, RepoParams, RepoResult, UpdatePrConfig } from '../types';
import type { GitlabIssue, GitlabPr } from './types';
export { extractRulesFromCodeOwnersLines } from './code-owners';
export declare function resetPlatform(): void;
export declare const id = "gitlab";
export declare function initPlatform({ endpoint, username, token, gitAuthor, }: PlatformParams): Promise<PlatformResult>;
export declare function getRepos(config?: AutodiscoverConfig): Promise<string[]>;
export declare function getRawFile(fileName: string, repoName?: string, branchOrTag?: string): Promise<string | null>;
export declare function getJsonFile(fileName: string, repoName?: string, branchOrTag?: string): Promise<any>;
export declare function initRepo({ repository, cloneSubmodules, cloneSubmodulesFilter, ignorePrAuthor, gitUrl, endpoint, includeMirrors, }: RepoParams): Promise<RepoResult>;
export declare function getBranchForceRebase(): Promise<boolean>;
export declare function getBranchStatus(branchName: string, internalChecksAsSuccess: boolean): Promise<BranchStatus>;
export declare function getPrList(): Promise<Pr[]>;
export declare function createPr({ sourceBranch, targetBranch, prTitle, prBody: rawDescription, draftPR, labels, platformPrOptions, }: CreatePRConfig): Promise<Pr>;
export declare function getPr(iid: number): Promise<GitlabPr>;
export declare function updatePr({ number: iid, prTitle, prBody: description, addLabels, removeLabels, state, platformPrOptions, targetBranch, }: UpdatePrConfig): Promise<void>;
export declare function reattemptPlatformAutomerge({ number: iid, platformPrOptions, }: ReattemptPlatformAutomergeConfig): Promise<void>;
export declare function mergePr({ id }: MergePRConfig): Promise<boolean>;
export declare function massageMarkdown(input: string): string;
export declare function maxBodyLength(): number;
export declare function labelCharLimit(): number;
export declare function findPr({ branchName, prTitle, state, includeOtherAuthors, }: FindPRConfig): Promise<Pr | null>;
export declare function getBranchPr(branchName: string): Promise<GitlabPr | null>;
export declare function getBranchStatusCheck(branchName: string, context: string): Promise<BranchStatus | null>;
export declare function setBranchStatus({ branchName, context, description, state: renovateState, url: targetUrl, }: BranchStatusConfig): Promise<void>;
export declare function getIssueList(): Promise<GitlabIssue[]>;
export declare function getIssue(number: number, useCache?: boolean): Promise<Issue | null>;
export declare function findIssue(title: string): Promise<Issue | null>;
export declare function ensureIssue({ title, reuseTitle, body, labels, confidential, }: EnsureIssueConfig): Promise<'updated' | 'created' | null>;
export declare function ensureIssueClosing(title: string): Promise<void>;
export declare function addAssignees(iid: number, assignees: string[]): Promise<void>;
export declare function addReviewers(iid: number, reviewers: string[]): Promise<void>;
export declare function deleteLabel(issueNo: number, label: string): Promise<void>;
export declare function ensureComment({ number, topic, content, }: EnsureCommentConfig): Promise<boolean>;
export declare function ensureCommentRemoval(deleteConfig: EnsureCommentRemovalConfig): Promise<void>;
export declare function filterUnavailableUsers(users: string[]): Promise<string[]>;
export declare function expandGroupMembers(reviewersOrAssignees: string[]): Promise<string[]>;
