"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.gitlabApi = void 0;
exports.getUserID = getUserID;
exports.getMemberUserIDs = getMemberUserIDs;
exports.getMemberUsernames = getMemberUsernames;
exports.isUserBusy = isUserBusy;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../logger");
const gitlab_1 = require("../../../util/http/gitlab");
exports.gitlabApi = new gitlab_1.GitlabHttp();
async function getUserID(username) {
    const userInfo = (await exports.gitlabApi.getJsonUnchecked(`users?username=${username}`)).body;
    if (is_1.default.emptyArray(userInfo)) {
        throw new Error(`User ID for the username: ${username} could not be found.`);
    }
    return userInfo[0].id;
}
async function getMembers(group) {
    const groupEncoded = encodeURIComponent(group);
    return (await exports.gitlabApi.getJsonUnchecked(`groups/${groupEncoded}/members`)).body;
}
async function getMemberUserIDs(group) {
    const members = await getMembers(group);
    return members.map((u) => u.id);
}
async function getMemberUsernames(group) {
    const members = await getMembers(group);
    return members.map((u) => u.username);
}
async function isUserBusy(user) {
    try {
        const url = `/users/${user}/status`;
        const userStatus = (await exports.gitlabApi.getJsonUnchecked(url))
            .body;
        return userStatus.availability === 'busy';
    }
    catch (err) {
        logger_1.logger.warn({ err }, 'Failed to get user status');
        return false;
    }
}
//# sourceMappingURL=http.js.map