"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractRulesFromCodeOwnersLines = extractRulesFromCodeOwnersLines;
const tslib_1 = require("tslib");
const ignore_1 = tslib_1.__importDefault(require("ignore"));
const regex_1 = require("../../../util/regex");
function extractRulesFromCodeOwnersLines(cleanedLines) {
    let currentSection = { name: '', defaultUsers: [] };
    const internalRules = [];
    for (const line of cleanedLines) {
        if (isSectionHeader(line)) {
            currentSection = changeCurrentSection(line);
        }
        else {
            const rule = extractOwnersFromLine(line, currentSection.defaultUsers);
            internalRules.push(rule);
        }
    }
    return internalRules;
}
function changeCurrentSection(line) {
    // Find the last closing bracket to handle section names with approval counts
    const lastClosingBracketIndex = line.lastIndexOf(']');
    // Extract section name (including any approval counts)
    const sectionName = line.substring(0, lastClosingBracketIndex + 1);
    const remainingLine = line.substring(lastClosingBracketIndex + 1).trim();
    // Parse any default users after the section name
    const usernames = remainingLine ? remainingLine.split((0, regex_1.regEx)(/\s+/)) : [];
    return { name: sectionName, defaultUsers: usernames };
}
function extractOwnersFromLine(line, defaultUsernames) {
    const [pattern, ...usernames] = line.split((0, regex_1.regEx)(/\s+/));
    const matchPattern = (0, ignore_1.default)().add(pattern);
    return {
        usernames: usernames.length > 0 ? usernames : defaultUsernames,
        pattern,
        score: pattern.length,
        match: (path) => matchPattern.ignores(path),
    };
}
function isSectionHeader(line) {
    return line.startsWith('[') || line.startsWith('^[');
}
//# sourceMappingURL=code-owners.js.map