"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAppDetails = getAppDetails;
exports.getUserDetails = getUserDetails;
exports.getUserEmail = getUserEmail;
const tslib_1 = require("tslib");
const logger_1 = require("../../../logger");
const githubHttp = tslib_1.__importStar(require("../../../util/http/github"));
const githubApi = new githubHttp.GithubHttp();
async function getAppDetails(token) {
    try {
        const appData = await githubApi.requestGraphql('query { viewer { login databaseId }}', { token });
        if (!appData?.data) {
            throw new Error("Init: Can't get App details");
        }
        return {
            username: appData.data.viewer.login,
            name: appData.data.viewer.login,
            id: appData.data.viewer.databaseId,
        };
    }
    catch (err) {
        logger_1.logger.debug({ err }, 'Error authenticating with GitHub');
        throw new Error('Init: Authentication failure');
    }
}
async function getUserDetails(endpoint, token) {
    try {
        const userData = (await githubApi.getJsonUnchecked(endpoint + 'user', {
            token,
        })).body;
        return {
            username: userData.login,
            name: userData.name,
            id: userData.id,
        };
    }
    catch (err) {
        logger_1.logger.debug({ err }, 'Error authenticating with GitHub');
        throw new Error('Init: Authentication failure');
    }
}
async function getUserEmail(endpoint, token) {
    try {
        const emails = (await githubApi.getJsonUnchecked(endpoint + 'user/emails', {
            token,
        })).body;
        return emails?.[0].email ?? null;
    }
    catch {
        logger_1.logger.debug('Cannot read user/emails endpoint on GitHub to retrieve gitAuthor');
        return null;
    }
}
//# sourceMappingURL=user.js.map