"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubScm = void 0;
const tslib_1 = require("tslib");
const git = tslib_1.__importStar(require("../../../util/git"));
const default_scm_1 = require("../default-scm");
const _1 = require("./");
class GithubScm extends default_scm_1.DefaultGitScm {
    commitAndPush(commitConfig) {
        let platformCommit = commitConfig.platformCommit;
        if (platformCommit === 'auto' && (0, _1.isGHApp)()) {
            platformCommit = 'enabled';
        }
        return platformCommit === 'enabled'
            ? (0, _1.commitFiles)(commitConfig)
            : git.commitFiles(commitConfig);
    }
}
exports.GithubScm = GithubScm;
//# sourceMappingURL=scm.js.map