"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubContentResponse = exports.GithubElement = exports.GithubOtherContent = exports.GithubDirectory = exports.GithubFile = exports.GithubFileMeta = exports.VulnerabilityAlertSchema = void 0;
const zod_1 = require("zod");
const logger_1 = require("../../../logger");
const schema_utils_1 = require("../../../util/schema-utils");
const PackageSchema = zod_1.z.object({
    ecosystem: zod_1.z.union([
        zod_1.z.literal('maven'),
        zod_1.z.literal('npm'),
        zod_1.z.literal('nuget'),
        zod_1.z.literal('pip'),
        zod_1.z.literal('rubygems'),
        zod_1.z.literal('rust'),
        zod_1.z.literal('composer'),
        zod_1.z.literal('go'),
    ]),
    name: zod_1.z.string(),
});
const SecurityVulnerabilitySchema = zod_1.z
    .object({
    first_patched_version: zod_1.z.object({ identifier: zod_1.z.string() }).nullish(),
    package: PackageSchema,
    vulnerable_version_range: zod_1.z.string(),
})
    .nullable();
const SecurityAdvisorySchema = zod_1.z.object({
    description: zod_1.z.string(),
    identifiers: zod_1.z.array(zod_1.z.object({
        type: zod_1.z.string(),
        value: zod_1.z.string(),
    })),
    references: zod_1.z.array(zod_1.z.object({ url: zod_1.z.string() })).optional(),
});
exports.VulnerabilityAlertSchema = (0, schema_utils_1.LooseArray)(zod_1.z.object({
    dismissed_reason: zod_1.z.string().nullish(),
    security_advisory: SecurityAdvisorySchema,
    security_vulnerability: SecurityVulnerabilitySchema,
    dependency: zod_1.z.object({
        manifest_path: zod_1.z.string(),
    }),
}), {
    /* v8 ignore start */
    onError: ({ error }) => {
        logger_1.logger.debug({ error }, 'Vulnerability Alert: Failed to parse some alerts');
    },
    /* v8 ignore stop */
});
// https://docs.github.com/en/rest/repos/contents?apiVersion=2022-11-28#get-repository-content
const GithubResponseMetadata = zod_1.z.object({
    name: zod_1.z.string(),
    path: zod_1.z.string(),
});
exports.GithubFileMeta = GithubResponseMetadata.extend({
    type: zod_1.z.literal('file'),
});
exports.GithubFile = exports.GithubFileMeta.extend({
    content: zod_1.z.string(),
    encoding: zod_1.z.string(),
});
exports.GithubDirectory = GithubResponseMetadata.extend({
    type: zod_1.z.literal('dir'),
});
exports.GithubOtherContent = GithubResponseMetadata.extend({
    type: zod_1.z.literal('symlink').or(zod_1.z.literal('submodule')),
});
exports.GithubElement = exports.GithubFile.or(exports.GithubFileMeta)
    .or(exports.GithubDirectory)
    .or(exports.GithubOtherContent);
exports.GithubContentResponse = zod_1.z.array(exports.GithubElement).or(exports.GithubElement);
//# sourceMappingURL=schema.js.map