import { z } from 'zod';
export declare const GithubIssue: z.ZodUnion<[z.ZodEffects<z.ZodObject<{
    number: z.ZodNumber;
    state: z.ZodEffects<z.ZodString, string, string>;
    title: z.ZodString;
    body: z.ZodString;
} & {
    updatedAt: z.ZodString;
}, "strip", z.ZodTypeAny, {
    number: number;
    body: string;
    state: string;
    updatedAt: string;
    title: string;
}, {
    number: number;
    body: string;
    state: string;
    updatedAt: string;
    title: string;
}>, {
    number: number;
    state: string;
    title: string;
    body: string;
    lastModified: string;
}, {
    number: number;
    body: string;
    state: string;
    updatedAt: string;
    title: string;
}>, z.ZodEffects<z.ZodObject<{
    number: z.ZodNumber;
    state: z.ZodEffects<z.ZodString, string, string>;
    title: z.ZodString;
    body: z.ZodString;
} & {
    updated_at: z.ZodString;
}, "strip", z.ZodTypeAny, {
    number: number;
    body: string;
    state: string;
    title: string;
    updated_at: string;
}, {
    number: number;
    body: string;
    state: string;
    title: string;
    updated_at: string;
}>, {
    number: number;
    state: string;
    title: string;
    body: string;
    lastModified: string;
}, {
    number: number;
    body: string;
    state: string;
    title: string;
    updated_at: string;
}>]>;
export type GithubIssue = z.infer<typeof GithubIssue>;
export declare class GithubIssueCache {
    private static reset;
    private static get data();
    static getIssues(): GithubIssue[] | null;
    static setIssues(issues: GithubIssue[]): void;
    static updateIssue(issue: GithubIssue): void;
    static deleteIssue(number: number): void;
    /**
     * At the moment of repo initialization, repository cache is not available.
     * What we can do is to store issues for later reconciliation.
     */
    static addIssuesToReconcile(issues: GithubIssue[] | undefined): void;
    private static reconcile;
}
