"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.enableAutoMergeMutation = exports.getIssuesQuery = exports.repoInfoQuery = void 0;
exports.repoInfoQuery = `
query($owner: String!, $name: String!, $user: String) {
  repository(owner: $owner, name: $name) {
    id
    isFork
    parent {
      nameWithOwner
    }
    isArchived
    nameWithOwner
    hasIssuesEnabled
    hasVulnerabilityAlertsEnabled
    autoMergeAllowed
    mergeCommitAllowed
    rebaseMergeAllowed
    squashMergeAllowed
    defaultBranchRef {
      name
      target {
        oid
      }
    }
    issues(
      orderBy: { field: UPDATED_AT, direction: DESC },
      filterBy: { createdBy: $user },
      first: 5
    ) {
      nodes {
        number
        state
        title
        body
        updatedAt
      }
    }
  }
}
`;
exports.getIssuesQuery = `
query(
  $owner: String!,
  $name: String!,
  $user: String,
  $count: Int,
  $cursor: String
) {
  repository(owner: $owner, name: $name) {
    issues(
      orderBy: { field: UPDATED_AT, direction: DESC },
      filterBy: { createdBy: $user },
      first: $count,
      after: $cursor
    ) {
      pageInfo {
        endCursor
        hasNextPage
      }
      nodes {
        number
        state
        title
        body
        updatedAt
      }
    }
  }
}
`;
exports.enableAutoMergeMutation = `
mutation EnablePullRequestAutoMerge(
  $pullRequestId: ID!,
  $mergeMethod: PullRequestMergeMethod!,
) {
  enablePullRequestAutoMerge(
    input: {
      pullRequestId: $pullRequestId,
      mergeMethod: $mergeMethod,
    }
  ) {
    pullRequest {
      number
    }
  }
}
`;
//# sourceMappingURL=graphql.js.map