export declare const repoInfoQuery = "\nquery($owner: String!, $name: String!, $user: String) {\n  repository(owner: $owner, name: $name) {\n    id\n    isFork\n    parent {\n      nameWithOwner\n    }\n    isArchived\n    nameWithOwner\n    hasIssuesEnabled\n    hasVulnerabilityAlertsEnabled\n    autoMergeAllowed\n    mergeCommitAllowed\n    rebaseMergeAllowed\n    squashMergeAllowed\n    defaultBranchRef {\n      name\n      target {\n        oid\n      }\n    }\n    issues(\n      orderBy: { field: UPDATED_AT, direction: DESC },\n      filterBy: { createdBy: $user },\n      first: 5\n    ) {\n      nodes {\n        number\n        state\n        title\n        body\n        updatedAt\n      }\n    }\n  }\n}\n";
export declare const getIssuesQuery = "\nquery(\n  $owner: String!,\n  $name: String!,\n  $user: String,\n  $count: Int,\n  $cursor: String\n) {\n  repository(owner: $owner, name: $name) {\n    issues(\n      orderBy: { field: UPDATED_AT, direction: DESC },\n      filterBy: { createdBy: $user },\n      first: $count,\n      after: $cursor\n    ) {\n      pageInfo {\n        endCursor\n        hasNextPage\n      }\n      nodes {\n        number\n        state\n        title\n        body\n        updatedAt\n      }\n    }\n  }\n}\n";
export declare const enableAutoMergeMutation = "\nmutation EnablePullRequestAutoMerge(\n  $pullRequestId: ID!,\n  $mergeMethod: PullRequestMergeMethod!,\n) {\n  enablePullRequestAutoMerge(\n    input: {\n      pullRequestId: $pullRequestId,\n      mergeMethod: $mergeMethod,\n    }\n  ) {\n    pullRequest {\n      number\n    }\n  }\n}\n";
