"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.githubApi = void 0;
exports.coerceRestPr = coerceRestPr;
exports.mapMergeStartegy = mapMergeStartegy;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../logger");
const github_1 = require("../../../util/http/github");
const pr_body_1 = require("../pr-body");
exports.githubApi = new github_1.GithubHttp();
/**
 * @see https://docs.github.com/en/rest/reference/pulls#list-pull-requests
 */
function coerceRestPr(pr) {
    const bodyStruct = pr.bodyStruct ?? (0, pr_body_1.getPrBodyStruct)(pr.body);
    const result = {
        number: pr.number,
        sourceBranch: pr.head?.ref,
        title: pr.title,
        state: pr.state === 'closed' && is_1.default.string(pr.merged_at) ? 'merged' : pr.state,
        bodyStruct,
        updated_at: pr.updated_at,
        node_id: pr.node_id,
    };
    if (pr.head?.sha) {
        result.sha = pr.head.sha;
    }
    if (pr.head?.repo?.full_name) {
        result.sourceRepo = pr.head.repo.full_name;
    }
    if (pr.labels) {
        result.labels = pr.labels.map(({ name }) => name);
    }
    if (!!pr.assignee || is_1.default.nonEmptyArray(pr.assignees)) {
        result.hasAssignees = true;
    }
    if (pr.requested_reviewers) {
        result.reviewers = pr.requested_reviewers
            .map(({ login }) => login)
            .filter(is_1.default.nonEmptyString);
    }
    if (pr.created_at) {
        result.createdAt = pr.created_at;
    }
    if (pr.closed_at) {
        result.closedAt = pr.closed_at;
    }
    if (pr.base?.ref) {
        result.targetBranch = pr.base.ref;
    }
    return result;
}
function mapMergeStartegy(strategy) {
    switch (strategy) {
        case 'auto':
            return undefined;
        case 'fast-forward': {
            logger_1.logger.warn('Fast-forward merge strategy is not supported by Github. Falling back to merge strategy set for the repository.');
            return undefined;
        }
        case 'merge-commit':
            return 'merge';
        default:
            return strategy;
    }
}
//# sourceMappingURL=common.js.map