"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.remoteBranchExists = remoteBranchExists;
const zod_1 = require("zod");
const regex_1 = require("../../../util/regex");
const common_1 = require("./common");
const MatchingRef = zod_1.z
    .object({ ref: zod_1.z.string() })
    .transform(({ ref }) => ref.replace((0, regex_1.regEx)(/^refs\/heads\//), ''))
    .array();
async function matchingBranches(repo, branchName) {
    const { body: branches } = await common_1.githubApi.getJson(`/repos/${repo}/git/matching-refs/heads/${branchName}`, { memCache: false }, MatchingRef);
    return branches;
}
async function remoteBranchExists(repo, branchName) {
    const branches = await matchingBranches(repo, branchName);
    if (branches.some((branch) => branch.startsWith(`${branchName}/`))) {
        const message = `Trying to create a branch '${branchName}' while it's the part of nested branch`;
        throw new Error(message);
    }
    return branches.includes(branchName);
}
//# sourceMappingURL=branch.js.map