import { z } from 'zod';
export declare const ContentsResponseSchema: z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
    type: z.ZodUnion<[z.ZodLiteral<"file">, z.ZodLiteral<"dir">]>;
    content: z.ZodNullable<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "file" | "dir";
    name: string;
    content: string | null;
}, {
    path: string;
    type: "file" | "dir";
    name: string;
    content: string | null;
}>;
export type ContentsResponse = z.infer<typeof ContentsResponseSchema>;
export declare const ContentsListResponseSchema: z.ZodArray<z.ZodObject<{
    name: z.ZodString;
    path: z.ZodString;
    type: z.ZodUnion<[z.ZodLiteral<"file">, z.ZodLiteral<"dir">]>;
    content: z.ZodNullable<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    path: string;
    type: "file" | "dir";
    name: string;
    content: string | null;
}, {
    path: string;
    type: "file" | "dir";
    name: string;
    content: string | null;
}>, "many">;
