import type { BranchStatus, PrState } from '../../../types';
import type { Pr } from '../types';
import type { GerritChange, GerritChangeStatus, GerritLabelTypeInfo, GerritRequestDetail } from './types';
export declare const TAG_PULL_REQUEST_BODY = "pull-request";
export declare const REQUEST_DETAILS_FOR_PRS: GerritRequestDetail[];
export declare function getGerritRepoUrl(repository: string, endpoint: string): string;
export declare function mapPrStateToGerritFilter(state?: PrState): string | null;
export declare function mapGerritChangeToPr(change: GerritChange, knownProperties?: {
    sourceBranch?: string;
    prBody?: string;
}): Pr | null;
export declare function mapGerritChangeStateToPrState(state: GerritChangeStatus): 'merged' | 'open' | 'closed';
export declare function extractSourceBranch(change: GerritChange): string | undefined;
export declare function findPullRequestBody(change: GerritChange): string | undefined;
export declare function mapBranchStatusToLabel(state: BranchStatus | 'UNKNOWN', // suppress default path code removal
label: GerritLabelTypeInfo): number;
