"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DefaultGitScm = void 0;
const tslib_1 = require("tslib");
const git = tslib_1.__importStar(require("../../util/git"));
class DefaultGitScm {
    branchExists(branchName) {
        return Promise.resolve(git.branchExists(branchName));
    }
    commitAndPush(commitConfig) {
        return git.commitFiles(commitConfig);
    }
    deleteBranch(branchName) {
        return git.deleteBranch(branchName);
    }
    getBranchCommit(branchName) {
        return Promise.resolve(git.getBranchCommit(branchName));
    }
    isBranchBehindBase(branchName, baseBranch) {
        return git.isBranchBehindBase(branchName, baseBranch);
    }
    isBranchConflicted(baseBranch, branch) {
        return git.isBranchConflicted(baseBranch, branch);
    }
    isBranchModified(branchName, baseBranch) {
        return git.isBranchModified(branchName, baseBranch);
    }
    getFileList() {
        return git.getFileList();
    }
    checkoutBranch(branchName) {
        return git.checkoutBranch(branchName);
    }
    mergeAndPush(branchName) {
        return git.mergeBranch(branchName);
    }
    mergeToLocal(branchName) {
        return git.mergeToLocal(branchName);
    }
    syncForkWithUpstream(branchName) {
        return git.syncForkWithUpstream(branchName);
    }
}
exports.DefaultGitScm = DefaultGitScm;
//# sourceMappingURL=default-scm.js.map