import type { EnsureCommentConfig, EnsureCommentRemovalConfig } from '../types';
import type { Account, Config } from './types';
export declare const REOPEN_PR_COMMENT_KEYWORD = "reopen!";
interface Comment {
    content: {
        raw: string;
    };
    id: number;
    user: Account;
}
export type CommentsConfig = Pick<Config, 'repository'>;
interface EnsureBitbucketCommentConfig extends EnsureCommentConfig {
    config: CommentsConfig;
}
export declare function ensureComment({ config, number: prNo, topic, content, }: EnsureBitbucketCommentConfig): Promise<boolean>;
export declare function reopenComments(config: CommentsConfig, prNo: number): Promise<Comment[]>;
export declare function ensureCommentRemoval(config: CommentsConfig, deleteConfig: EnsureCommentRemovalConfig): Promise<void>;
export {};
