import { z } from 'zod';
export declare const UserSchema: z.ZodObject<{
    displayName: z.ZodString;
    emailAddress: z.ZodString;
}, "strip", z.ZodTypeAny, {
    displayName: string;
    emailAddress: string;
}, {
    displayName: string;
    emailAddress: string;
}>;
export declare const Files: z.ZodArray<z.ZodString, "many">;
export declare const Comment: z.ZodObject<{
    text: z.ZodString;
    id: z.ZodNumber;
}, "strip", z.ZodTypeAny, {
    id: number;
    text: string;
}, {
    id: number;
    text: string;
}>;
export type Comment = z.infer<typeof Comment>;
export declare const PullRequestCommentActivity: z.ZodObject<{
    action: z.ZodLiteral<"COMMENTED">;
    commentAction: z.ZodString;
    comment: z.ZodObject<{
        text: z.ZodString;
        id: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        id: number;
        text: string;
    }, {
        id: number;
        text: string;
    }>;
}, "strip", z.ZodTypeAny, {
    action: "COMMENTED";
    comment: {
        id: number;
        text: string;
    };
    commentAction: string;
}, {
    action: "COMMENTED";
    comment: {
        id: number;
        text: string;
    };
    commentAction: string;
}>;
export type PullRequestCommentActivity = z.infer<typeof PullRequestCommentActivity>;
export declare const PullRequestActivity: z.ZodUnion<[z.ZodObject<{
    action: z.ZodString;
}, "strip", z.ZodTypeAny, {
    action: string;
}, {
    action: string;
}>, z.ZodObject<{
    action: z.ZodLiteral<"COMMENTED">;
    commentAction: z.ZodString;
    comment: z.ZodObject<{
        text: z.ZodString;
        id: z.ZodNumber;
    }, "strip", z.ZodTypeAny, {
        id: number;
        text: string;
    }, {
        id: number;
        text: string;
    }>;
}, "strip", z.ZodTypeAny, {
    action: "COMMENTED";
    comment: {
        id: number;
        text: string;
    };
    commentAction: string;
}, {
    action: "COMMENTED";
    comment: {
        id: number;
        text: string;
    };
    commentAction: string;
}>]>;
export type PullRequestActivity = z.infer<typeof PullRequestActivity>;
