"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WrappedExceptionSchema = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
const WrappedException = zod_1.z.lazy(() => zod_1.z.object({
    customProperties: zod_1.z.record(zod_1.z.any()).optional(),
    errorCode: zod_1.z.number().optional(),
    eventId: zod_1.z.number().optional(),
    helpLink: zod_1.z.string().optional(),
    innerException: WrappedException.optional(),
    message: zod_1.z.string().optional(),
    stackTrace: zod_1.z.string().optional(),
    typeKey: zod_1.z.string().optional(),
    typeName: zod_1.z.string().optional(),
}));
exports.WrappedExceptionSchema = schema_utils_1.Json.pipe(WrappedException);
//# sourceMappingURL=schema.js.map