import type { BranchStatus } from '../../../types';
import type { BranchStatusConfig, CreatePRConfig, EnsureCommentConfig, EnsureCommentRemovalConfig, EnsureIssueResult, FindPRConfig, Issue, MergePRConfig, PlatformParams, PlatformResult, Pr, RepoParams, RepoResult, UpdatePrConfig } from '../types';
import type { AzurePr } from './types';
export declare const id = "azure";
export declare function initPlatform({ endpoint, token, username, password, }: PlatformParams): Promise<PlatformResult>;
export declare function getRepos(): Promise<string[]>;
export declare function getRawFile(fileName: string, repoName?: string, branchOrTag?: string): Promise<string | null>;
export declare function getJsonFile(fileName: string, repoName?: string, branchOrTag?: string): Promise<any>;
export declare function initRepo({ repository, cloneSubmodules, cloneSubmodulesFilter, }: RepoParams): Promise<RepoResult>;
export declare function getPrList(): Promise<AzurePr[]>;
export declare function getPr(pullRequestId: number): Promise<Pr | null>;
export declare function findPr({ branchName, prTitle, state, targetBranch, }: FindPRConfig): Promise<Pr | null>;
export declare function getBranchPr(branchName: string, targetBranch?: string): Promise<Pr | null>;
export declare function getBranchStatusCheck(branchName: string, context: string): Promise<BranchStatus | null>;
export declare function getBranchStatus(branchName: string, internalChecksAsSuccess: boolean): Promise<BranchStatus>;
export declare function createPr({ sourceBranch, targetBranch, prTitle: title, prBody: body, labels, draftPR, platformPrOptions, }: CreatePRConfig): Promise<Pr>;
export declare function updatePr({ number: prNo, prTitle: title, prBody: body, state, platformPrOptions, targetBranch, }: UpdatePrConfig): Promise<void>;
export declare function ensureComment({ number, topic, content, }: EnsureCommentConfig): Promise<boolean>;
export declare function ensureCommentRemoval(removeConfig: EnsureCommentRemovalConfig): Promise<void>;
export declare function setBranchStatus({ branchName, context, description, state, url: targetUrl, }: BranchStatusConfig): Promise<void>;
export declare function mergePr({ branchName, id: pullRequestId, strategy, }: MergePRConfig): Promise<boolean>;
export declare function massageMarkdown(input: string): string;
export declare function maxBodyLength(): number;
export declare function findIssue(): Promise<Issue | null>;
export declare function ensureIssue(): Promise<EnsureIssueResult | null>;
export declare function ensureIssueClosing(): Promise<void>;
export declare function getIssueList(): Promise<Issue[]>;
/**
 *
 * @param {number} issueNo
 * @param {string[]} assignees
 */
export declare function addAssignees(issueNo: number, assignees: string[]): Promise<void>;
/**
 *
 * @param {number} prNo
 * @param {string[]} reviewers
 */
export declare function addReviewers(prNo: number, reviewers: string[]): Promise<void>;
export declare function deleteLabel(prNumber: number, label: string): Promise<void>;
