"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.azureObj = azureObj;
exports.gitApi = gitApi;
exports.coreApi = coreApi;
exports.policyApi = policyApi;
exports.setEndpoint = setEndpoint;
const tslib_1 = require("tslib");
const azure = tslib_1.__importStar(require("azure-devops-node-api"));
const azure_devops_node_api_1 = require("azure-devops-node-api");
const hostRules = tslib_1.__importStar(require("../../../util/host-rules"));
const hostType = 'azure';
let endpoint;
function getAuthenticationHandler(config) {
    if (!config.token && config.username && config.password) {
        return (0, azure_devops_node_api_1.getBasicHandler)(config.username, config.password, true);
    }
    // TODO: token can be undefined here (#22198)
    return (0, azure_devops_node_api_1.getHandlerFromToken)(config.token, true);
}
function azureObj() {
    const config = hostRules.find({ hostType, url: endpoint });
    if (!config.token && !(config.username && config.password)) {
        throw new Error(`No config found for azure`);
    }
    const authHandler = getAuthenticationHandler(config);
    return new azure.WebApi(endpoint, authHandler, {
        allowRetries: true,
        maxRetries: 2,
    });
}
function gitApi() {
    return azureObj().getGitApi();
}
function coreApi() {
    return azureObj().getCoreApi();
}
function policyApi() {
    return azureObj().getPolicyApi();
}
function setEndpoint(e) {
    endpoint = e;
}
//# sourceMappingURL=azure-got-wrapper.js.map