"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Vendir = exports.Contents = exports.GithubReleaseContent = exports.GitRefContent = exports.HelmChartContent = exports.HelmChart = exports.GithubRelease = exports.GitRef = exports.VendirResource = void 0;
const zod_1 = require("zod");
const regex_1 = require("../../../util/regex");
const schema_utils_1 = require("../../../util/schema-utils");
exports.VendirResource = zod_1.z.object({
    apiVersion: zod_1.z.literal('vendir.k14s.io/v1alpha1'),
    kind: zod_1.z.literal('Config'),
});
exports.GitRef = zod_1.z.object({
    ref: zod_1.z.string(),
    url: zod_1.z.string().regex((0, regex_1.regEx)(/^(?:ssh|https?):\/\/.+/)),
    depth: zod_1.z.number().optional(),
});
exports.GithubRelease = zod_1.z.object({
    slug: zod_1.z.string(),
    tag: zod_1.z.string(),
});
exports.HelmChart = zod_1.z.object({
    name: zod_1.z.string(),
    version: zod_1.z.string(),
    repository: zod_1.z.object({
        url: zod_1.z.string().regex((0, regex_1.regEx)(/^(?:oci|https?):\/\/.+/)),
    }),
});
exports.HelmChartContent = zod_1.z.object({
    path: zod_1.z.string(),
    helmChart: exports.HelmChart,
});
exports.GitRefContent = zod_1.z.object({
    path: zod_1.z.string(),
    git: exports.GitRef,
});
exports.GithubReleaseContent = zod_1.z.object({
    path: zod_1.z.string(),
    githubRelease: exports.GithubRelease,
});
exports.Contents = zod_1.z.union([
    exports.HelmChartContent,
    exports.GitRefContent,
    exports.GithubReleaseContent,
]);
exports.Vendir = exports.VendirResource.extend({
    directories: zod_1.z.array(zod_1.z.object({
        path: zod_1.z.string(),
        contents: (0, schema_utils_1.LooseArray)(exports.Contents),
    })),
});
//# sourceMappingURL=schema.js.map