import { z } from 'zod';
export declare const VendirResource: z.ZodObject<{
    apiVersion: z.ZodLiteral<"vendir.k14s.io/v1alpha1">;
    kind: z.ZodLiteral<"Config">;
}, "strip", z.ZodTypeAny, {
    apiVersion: "vendir.k14s.io/v1alpha1";
    kind: "Config";
}, {
    apiVersion: "vendir.k14s.io/v1alpha1";
    kind: "Config";
}>;
export declare const GitRef: z.ZodObject<{
    ref: z.ZodString;
    url: z.ZodString;
    depth: z.ZodOptional<z.ZodNumber>;
}, "strip", z.ZodTypeAny, {
    url: string;
    ref: string;
    depth?: number | undefined;
}, {
    url: string;
    ref: string;
    depth?: number | undefined;
}>;
export declare const GithubRelease: z.ZodObject<{
    slug: z.ZodString;
    tag: z.ZodString;
}, "strip", z.ZodTypeAny, {
    tag: string;
    slug: string;
}, {
    tag: string;
    slug: string;
}>;
export declare const HelmChart: z.ZodObject<{
    name: z.ZodString;
    version: z.ZodString;
    repository: z.ZodObject<{
        url: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        url: string;
    }, {
        url: string;
    }>;
}, "strip", z.ZodTypeAny, {
    name: string;
    version: string;
    repository: {
        url: string;
    };
}, {
    name: string;
    version: string;
    repository: {
        url: string;
    };
}>;
export declare const HelmChartContent: z.ZodObject<{
    path: z.ZodString;
    helmChart: z.ZodObject<{
        name: z.ZodString;
        version: z.ZodString;
        repository: z.ZodObject<{
            url: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            url: string;
        }, {
            url: string;
        }>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        version: string;
        repository: {
            url: string;
        };
    }, {
        name: string;
        version: string;
        repository: {
            url: string;
        };
    }>;
}, "strip", z.ZodTypeAny, {
    path: string;
    helmChart: {
        name: string;
        version: string;
        repository: {
            url: string;
        };
    };
}, {
    path: string;
    helmChart: {
        name: string;
        version: string;
        repository: {
            url: string;
        };
    };
}>;
export declare const GitRefContent: z.ZodObject<{
    path: z.ZodString;
    git: z.ZodObject<{
        ref: z.ZodString;
        url: z.ZodString;
        depth: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        url: string;
        ref: string;
        depth?: number | undefined;
    }, {
        url: string;
        ref: string;
        depth?: number | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    path: string;
    git: {
        url: string;
        ref: string;
        depth?: number | undefined;
    };
}, {
    path: string;
    git: {
        url: string;
        ref: string;
        depth?: number | undefined;
    };
}>;
export declare const GithubReleaseContent: z.ZodObject<{
    path: z.ZodString;
    githubRelease: z.ZodObject<{
        slug: z.ZodString;
        tag: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        tag: string;
        slug: string;
    }, {
        tag: string;
        slug: string;
    }>;
}, "strip", z.ZodTypeAny, {
    path: string;
    githubRelease: {
        tag: string;
        slug: string;
    };
}, {
    path: string;
    githubRelease: {
        tag: string;
        slug: string;
    };
}>;
export declare const Contents: z.ZodUnion<[z.ZodObject<{
    path: z.ZodString;
    helmChart: z.ZodObject<{
        name: z.ZodString;
        version: z.ZodString;
        repository: z.ZodObject<{
            url: z.ZodString;
        }, "strip", z.ZodTypeAny, {
            url: string;
        }, {
            url: string;
        }>;
    }, "strip", z.ZodTypeAny, {
        name: string;
        version: string;
        repository: {
            url: string;
        };
    }, {
        name: string;
        version: string;
        repository: {
            url: string;
        };
    }>;
}, "strip", z.ZodTypeAny, {
    path: string;
    helmChart: {
        name: string;
        version: string;
        repository: {
            url: string;
        };
    };
}, {
    path: string;
    helmChart: {
        name: string;
        version: string;
        repository: {
            url: string;
        };
    };
}>, z.ZodObject<{
    path: z.ZodString;
    git: z.ZodObject<{
        ref: z.ZodString;
        url: z.ZodString;
        depth: z.ZodOptional<z.ZodNumber>;
    }, "strip", z.ZodTypeAny, {
        url: string;
        ref: string;
        depth?: number | undefined;
    }, {
        url: string;
        ref: string;
        depth?: number | undefined;
    }>;
}, "strip", z.ZodTypeAny, {
    path: string;
    git: {
        url: string;
        ref: string;
        depth?: number | undefined;
    };
}, {
    path: string;
    git: {
        url: string;
        ref: string;
        depth?: number | undefined;
    };
}>, z.ZodObject<{
    path: z.ZodString;
    githubRelease: z.ZodObject<{
        slug: z.ZodString;
        tag: z.ZodString;
    }, "strip", z.ZodTypeAny, {
        tag: string;
        slug: string;
    }, {
        tag: string;
        slug: string;
    }>;
}, "strip", z.ZodTypeAny, {
    path: string;
    githubRelease: {
        tag: string;
        slug: string;
    };
}, {
    path: string;
    githubRelease: {
        tag: string;
        slug: string;
    };
}>]>;
export declare const Vendir: z.ZodObject<{
    apiVersion: z.ZodLiteral<"vendir.k14s.io/v1alpha1">;
    kind: z.ZodLiteral<"Config">;
} & {
    directories: z.ZodArray<z.ZodObject<{
        path: z.ZodString;
        contents: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, ({
            path: string;
            helmChart: {
                name: string;
                version: string;
                repository: {
                    url: string;
                };
            };
        } | {
            path: string;
            git: {
                url: string;
                ref: string;
                depth?: number | undefined;
            };
        } | {
            path: string;
            githubRelease: {
                tag: string;
                slug: string;
            };
        })[], any[]>;
    }, "strip", z.ZodTypeAny, {
        path: string;
        contents: ({
            path: string;
            helmChart: {
                name: string;
                version: string;
                repository: {
                    url: string;
                };
            };
        } | {
            path: string;
            git: {
                url: string;
                ref: string;
                depth?: number | undefined;
            };
        } | {
            path: string;
            githubRelease: {
                tag: string;
                slug: string;
            };
        })[];
    }, {
        path: string;
        contents: any[];
    }>, "many">;
}, "strip", z.ZodTypeAny, {
    apiVersion: "vendir.k14s.io/v1alpha1";
    kind: "Config";
    directories: {
        path: string;
        contents: ({
            path: string;
            helmChart: {
                name: string;
                version: string;
                repository: {
                    url: string;
                };
            };
        } | {
            path: string;
            git: {
                url: string;
                ref: string;
                depth?: number | undefined;
            };
        } | {
            path: string;
            githubRelease: {
                tag: string;
                slug: string;
            };
        })[];
    }[];
}, {
    apiVersion: "vendir.k14s.io/v1alpha1";
    kind: "Config";
    directories: {
        path: string;
        contents: any[];
    }[];
}>;
export type VendirDefinition = z.infer<typeof Vendir>;
export type HelmChartDefinition = z.infer<typeof HelmChart>;
export type GitRefDefinition = z.infer<typeof GitRef>;
export type GithubReleaseDefinition = z.infer<typeof GithubRelease>;
