"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const regex_1 = require("../../../util/regex");
const unity3d_1 = require("../../datasource/unity3d");
const supportedKeys = ['m_EditorVersion', 'm_EditorVersionWithRevision'];
const UnityVersionRegex = (0, regex_1.regEx)(/^(?<depName>.+): (?<currentValue>.+)/);
function extractVersions(content) {
    const deps = [];
    for (const line of content.split('\n')) {
        const matches = UnityVersionRegex.exec(line);
        if (!matches?.groups) {
            continue;
        }
        const key = matches.groups.depName;
        const value = matches.groups.currentValue;
        if (!supportedKeys.includes(key)) {
            continue;
        }
        deps.push({
            currentValue: value,
            datasource: unity3d_1.Unity3dDatasource.id,
            depName: 'Unity Editor',
            packageName: key,
        });
    }
    return deps;
}
function extractPackageFile(content) {
    const deps = [];
    deps.push(...extractVersions(content));
    if (!deps.length) {
        return null;
    }
    return { deps };
}
//# sourceMappingURL=extract.js.map