"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateArtifacts = updateArtifacts;
const logger_1 = require("../../../logger");
const index_1 = require("../terraform/lockfile/index");
async function updateArtifacts(artifact) {
    if (!artifact.config.isLockFileMaintenance) {
        logger_1.logger.debug(`UpdateType ${artifact.config.updateType} is not supported for terragrunt`);
        return null;
    }
    return await (0, index_1.updateArtifacts)(artifact);
}
//# sourceMappingURL=artifacts.js.map