"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.updateLockedDependency = updateLockedDependency;
const logger_1 = require("../../../../logger");
const string_1 = require("../../../../util/string");
const util_1 = require("./util");
function updateLockedDependency(config) {
    const { depName, currentVersion, newVersion, lockFile, lockFileContent } = config;
    // TODO: fix types (#22198)
    logger_1.logger.debug(`terraform.updateLockedDependency: ${depName}@${currentVersion} -> ${newVersion} [${lockFile}]`);
    try {
        const locked = (0, util_1.extractLocks)((0, string_1.coerceString)(lockFileContent));
        const lockedDep = locked?.find((dep) => dep.packageName === (0, string_1.coerceString)(depName));
        if (lockedDep?.version === newVersion) {
            return { status: 'already-updated' };
        }
        return { status: 'unsupported' };
    }
    catch (err) {
        logger_1.logger.debug({ err }, 'terraform.updateLockedDependency() error');
        return { status: 'update-failed' };
    }
}
//# sourceMappingURL=update-locked.js.map