import { Http } from '../../../../util/http';
import { TerraformProviderDatasource } from '../../../datasource/terraform-provider';
import type { TerraformBuild } from '../../../datasource/terraform-provider/types';
export declare class TerraformProviderHash {
    static http: Http;
    static terraformDatasource: TerraformProviderDatasource;
    static hashCacheTTL: number;
    private static hashElementList;
    /**
     * This is a reimplementation of the Go H1 hash algorithm found at https://github.com/golang/mod/blob/master/sumdb/dirhash/hash.go
     * The package provides two function HashDir and HashZip where the first is for hashing the contents of a directory
     * and the second for doing the same but implicitly extracting the contents first.
     *
     * The problem starts with that there is a bug which leads to the fact that HashDir and HashZip do not return the same
     * hash if there are folders inside the content which should be hashed.
     *
     * In a folder structure such as
     * .
     * ├── Readme.md
     * └── readme-assets/
     *     └── image.jpg
     *
     * HashDir will create a list of following entries which in turn will hash again
     * aaaaaaaaaaa  Readme.md\n
     * ccccccccccc  readme-assets/image.jpg\n
     *
     * HashZip in contrast will not filter out the directory itself but rather includes it in the hash list
     * aaaaaaaaaaa  Readme.md\n
     * bbbbbbbbbbb  readme-assets/\n
     * ccccccccccc  readme-assets/image.jpg\n
     *
     * As the resulting string is used to generate the final hash it will differ based on which function has been used.
     * The issue is tracked here: https://github.com/golang/go/issues/53448
     *
     * This implementation follows the intended implementation and filters out folder entries.
     * Terraform seems NOT to use HashZip for provider validation, but rather extracts it and then do the hash calculation
     * even as both are set up in their code base.
     * https://github.com/hashicorp/terraform/blob/3fdfbd69448b14a4982b3c62a5d36835956fcbaa/internal/getproviders/hash.go#L283-L305
     *
     * @param zipFilePath path to the zip file
     * @param extractPath path to where to temporarily extract the data
     */
    static hashOfZipContent(zipFilePath: string, extractPath: string): Promise<string>;
    static hashOfDir(dirPath: string): Promise<string>;
    static calculateSingleHash(build: TerraformBuild, cacheDir: string): Promise<string>;
    static calculateHashScheme1Hashes(builds: TerraformBuild[]): Promise<string[]>;
    static createHashes(registryURL: string, repository: string, version: string): Promise<string[] | null>;
}
