"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RequiredProviderExtractor = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const base_1 = require("../../base");
class RequiredProviderExtractor extends base_1.TerraformProviderExtractor {
    getCheckList() {
        return ['required_providers'];
    }
    extract(hclRoot, locks) {
        const terraformBlocks = hclRoot?.terraform;
        if (is_1.default.nullOrUndefined(terraformBlocks)) {
            return [];
        }
        const dependencies = [];
        for (const terraformBlock of terraformBlocks) {
            const requiredProviders = terraformBlock.required_providers;
            if (is_1.default.nullOrUndefined(requiredProviders)) {
                continue;
            }
            const entries = requiredProviders.flatMap(Object.entries);
            for (const [requiredProviderName, value] of entries) {
                // name = version declaration method
                let dep;
                if (is_1.default.string(value)) {
                    dep = {
                        currentValue: value,
                        managerData: {
                            moduleName: requiredProviderName,
                        },
                    };
                }
                else {
                    // block declaration aws = { source = 'aws', version = '2.0.0' }
                    dep = {
                        currentValue: value.version,
                        managerData: {
                            moduleName: requiredProviderName,
                            source: value.source,
                        },
                    };
                }
                dependencies.push(this.analyzeTerraformProvider(dep, locks, 'required_provider'));
            }
        }
        return dependencies;
    }
}
exports.RequiredProviderExtractor = RequiredProviderExtractor;
//# sourceMappingURL=required-provider.js.map