"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformWorkspaceExtractor = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const terraform_version_1 = require("../terraform-block/terraform-version");
class TerraformWorkspaceExtractor extends terraform_version_1.TerraformVersionExtractor {
    getCheckList() {
        return [`"tfe_workspace"`];
    }
    extract(hclMap) {
        const dependencies = [];
        const workspaces = hclMap?.resource?.tfe_workspace;
        if (is_1.default.nullOrUndefined(workspaces)) {
            return [];
        }
        for (const workspace of Object.values(workspaces).flat()) {
            const dep = this.analyseTerraformVersion({
                currentValue: workspace.terraform_version,
            });
            if (is_1.default.nullOrUndefined(workspace.terraform_version)) {
                dep.skipReason = 'unspecified-version';
            }
            dependencies.push({
                ...dep,
                depType: 'tfe_workspace',
            });
        }
        return dependencies;
    }
}
exports.TerraformWorkspaceExtractor = TerraformWorkspaceExtractor;
//# sourceMappingURL=terraform-workspace.js.map