"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProvidersExtractor = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const logger_1 = require("../../../../../logger");
const base_1 = require("../../base");
class ProvidersExtractor extends base_1.TerraformProviderExtractor {
    getCheckList() {
        return ['provider'];
    }
    extract(hclRoot, locks) {
        const providerTypes = hclRoot?.provider;
        if (is_1.default.nullOrUndefined(providerTypes)) {
            return [];
        }
        // istanbul ignore if
        if (!is_1.default.plainObject(providerTypes)) {
            logger_1.logger.debug({ providerTypes }, 'Terraform: unexpected `providerTypes` value');
            return [];
        }
        const dependencies = [];
        for (const providerTypeName of Object.keys(providerTypes)) {
            for (const providerTypeElement of providerTypes[providerTypeName]) {
                const dep = this.analyzeTerraformProvider({
                    currentValue: providerTypeElement.version,
                    managerData: {
                        moduleName: providerTypeName,
                    },
                }, locks, 'provider');
                dependencies.push(dep);
            }
        }
        return dependencies;
    }
}
exports.ProvidersExtractor = ProvidersExtractor;
//# sourceMappingURL=providers.js.map