"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TerraformProviderExtractor = exports.DependencyExtractor = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const regex_1 = require("../../../util/regex");
const terraform_provider_1 = require("../../datasource/terraform-provider");
const util_1 = require("./util");
class DependencyExtractor {
}
exports.DependencyExtractor = DependencyExtractor;
class TerraformProviderExtractor extends DependencyExtractor {
    sourceExtractionRegex = (0, regex_1.regEx)(/^(?:(?<hostname>(?:[a-zA-Z0-9-_]+\.+)+[a-zA-Z0-9-_]+)\/)?(?:(?<namespace>[^/]+)\/)?(?<type>[^/]+)/);
    analyzeTerraformProvider(dep, locks, depType) {
        dep.depType = depType;
        dep.depName = dep.managerData?.moduleName;
        dep.datasource = terraform_provider_1.TerraformProviderDatasource.id;
        if (is_1.default.nonEmptyString(dep.managerData?.source)) {
            // TODO #22198
            const source = this.sourceExtractionRegex.exec(dep.managerData.source);
            if (!source?.groups) {
                dep.skipReason = 'unsupported-url';
                return dep;
            }
            // buildin providers https://github.com/terraform-providers
            if (source.groups.namespace === 'terraform-providers') {
                dep.registryUrls = [`https://releases.hashicorp.com`];
            }
            else if (source.groups.hostname) {
                dep.registryUrls = [`https://${source.groups.hostname}`];
                dep.packageName = `${source.groups.namespace}/${source.groups.type}`;
            }
            else {
                dep.packageName = dep.managerData?.source;
            }
        }
        (0, util_1.massageProviderLookupName)(dep);
        dep.lockedVersion = (0, util_1.getLockedVersion)(dep, locks);
        if (!dep.currentValue) {
            dep.skipReason = 'unspecified-version';
        }
        return dep;
    }
}
exports.TerraformProviderExtractor = TerraformProviderExtractor;
//# sourceMappingURL=base.js.map