import type { ExtractConfig, PackageDependency } from '../types';
import type { TerraformDefinitionFile } from './hcl/types';
import type { ProviderLock } from './lockfile/types';
export declare abstract class DependencyExtractor {
    /**
     * Get a list of signals which can be used to scan for potential processable content
     * @return a list of content signals
     */
    abstract getCheckList(): string[];
    /**
     * Extract dependencies from a HCL object
     * @param hclRoot HCL parsing artifact.
     * @param locks currently existing locks
     */
    abstract extract(hclRoot: TerraformDefinitionFile, locks: ProviderLock[], config: ExtractConfig): PackageDependency[];
}
export declare abstract class TerraformProviderExtractor extends DependencyExtractor {
    sourceExtractionRegex: RegExp;
    protected analyzeTerraformProvider(dep: PackageDependency, locks: ProviderLock[], depType: string): PackageDependency;
}
