export interface TektonResource {
    spec: TektonResourceSpec;
    items?: TektonResource[];
    metadata?: {
        annotations: Record<string, string>;
    };
}
export interface TektonResourceSpec {
    taskRef: TektonBundle;
    taskSpec?: TektonResourceSpec;
    pipelineRef: TektonBundle;
    pipelineSpec?: TektonResourceSpec;
    tasks: TektonResourceSpec[];
    finally?: TektonResourceSpec[];
    resourcetemplates: TektonResource[];
    steps?: TektonStep[];
    stepTemplate?: TektonStep;
    sidecars?: TektonStep[];
}
export interface TektonBundle {
    bundle: string;
    resolver: string;
    resource?: TektonResolverParamsField[];
    params?: TektonResolverParamsField[];
}
export interface TektonResolverParamsField {
    name: string;
    value: string;
}
export interface TektonStep {
    image?: string;
}
