"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.displayName = exports.getRangeStrategy = exports.extractPackageFile = void 0;
const tslib_1 = require("tslib");
const git_tags_1 = require("../../datasource/git-tags");
const swiftVersioning = tslib_1.__importStar(require("../../versioning/swift"));
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
var range_1 = require("./range");
Object.defineProperty(exports, "getRangeStrategy", { enumerable: true, get: function () { return range_1.getRangeStrategy; } });
exports.displayName = 'Swift Package Manager';
exports.url = 'https://www.swift.org/package-manager';
exports.categories = ['swift'];
exports.defaultConfig = {
    managerFilePatterns: ['/(^|/)Package\\.swift/'],
    versioning: swiftVersioning.id,
    pinDigests: false,
};
exports.supportedDatasources = [git_tags_1.GitTagsDatasource.id];
//# sourceMappingURL=index.js.map