"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.removeRepositoryName = removeRepositoryName;
const regex_1 = require("../../../util/regex");
function removeRepositoryName(repositoryName, chartName) {
    const repoNameWithSlash = (0, regex_1.regEx)(`^${repositoryName}/`, undefined, false);
    let modifiedChartName = chartName.replace(repoNameWithSlash, '');
    modifiedChartName = modifiedChartName.replace(/\/+$/, '');
    return modifiedChartName;
}
//# sourceMappingURL=util.js.map