"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bumpPackageVersion = bumpPackageVersion;
const tslib_1 = require("tslib");
const semver_1 = tslib_1.__importDefault(require("semver"));
const logger_1 = require("../../../logger");
const regex_1 = require("../../../util/regex");
function bumpPackageVersion(content, currentValue, bumpVersion) {
    logger_1.logger.debug({ bumpVersion, currentValue }, 'Checking if we should bump build.sbt version');
    let bumpedContent = content;
    const bumpedVersion = semver_1.default.inc(currentValue, bumpVersion);
    if (!bumpedVersion) {
        logger_1.logger.warn('Version incremental failed');
        return { bumpedContent };
    }
    bumpedContent = content.replace((0, regex_1.regEx)(/^(version\s*:=\s*).*$/m), `$1"${bumpedVersion}"`);
    if (bumpedContent === content) {
        logger_1.logger.debug('Version was already bumped');
    }
    else {
        logger_1.logger.debug(`Bumped build.sbt version to ${bumpedVersion}`);
    }
    return { bumpedContent };
}
//# sourceMappingURL=update.js.map