"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.displayName = exports.bumpPackageVersion = exports.extractPackageFile = exports.extractAllPackageFiles = void 0;
const tslib_1 = require("tslib");
const github_releases_1 = require("../../datasource/github-releases");
const maven_1 = require("../../datasource/maven");
const sbt_package_1 = require("../../datasource/sbt-package");
const sbt_plugin_1 = require("../../datasource/sbt-plugin");
const ivyVersioning = tslib_1.__importStar(require("../../versioning/ivy"));
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractAllPackageFiles", { enumerable: true, get: function () { return extract_1.extractAllPackageFiles; } });
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
var update_1 = require("./update");
Object.defineProperty(exports, "bumpPackageVersion", { enumerable: true, get: function () { return update_1.bumpPackageVersion; } });
exports.displayName = 'sbt';
exports.url = 'https://www.scala-sbt.org';
exports.categories = ['java'];
exports.defaultConfig = {
    managerFilePatterns: [
        '/\\.sbt$/',
        '/project/[^/]*\\.scala$/',
        '/project/build\\.properties$/',
        '/(^|/)repositories$/',
    ],
    versioning: ivyVersioning.id,
};
exports.supportedDatasources = [
    maven_1.MavenDatasource.id,
    sbt_package_1.SbtPackageDatasource.id,
    sbt_plugin_1.SbtPluginDatasource.id,
    github_releases_1.GithubReleasesDatasource.id, // For sbt itself
];
//# sourceMappingURL=index.js.map