"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractPackageFile = extractPackageFile;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const parse_1 = require("../../../config/presets/parse");
const logger_1 = require("../../../logger");
const gitea_tags_1 = require("../../datasource/gitea-tags");
const github_tags_1 = require("../../datasource/github-tags");
const gitlab_tags_1 = require("../../datasource/gitlab-tags");
const schema_1 = require("./schema");
const supportedPresetSources = {
    github: github_tags_1.GithubTagsDatasource.id,
    gitlab: gitlab_tags_1.GitlabTagsDatasource.id,
    gitea: gitea_tags_1.GiteaTagsDatasource.id,
};
function extractPackageFile(content, packageFile) {
    logger_1.logger.trace(`renovate-config-presets.extractPackageFile(${packageFile})`);
    const config = schema_1.RenovateJsonSchema.safeParse(content);
    if (!config.success) {
        logger_1.logger.debug({ packageFile, err: config.error }, 'Invalid Renovate Config');
        return null;
    }
    const deps = [];
    for (const preset of config.data.extends ?? []) {
        const parsedPreset = (0, parse_1.parsePreset)(preset);
        const datasource = supportedPresetSources[parsedPreset.presetSource];
        if (is_1.default.nullOrUndefined(datasource)) {
            if (parsedPreset.presetSource !== 'internal') {
                deps.push({
                    depName: parsedPreset.repo,
                    skipReason: 'unsupported-datasource',
                });
            }
            continue;
        }
        if (is_1.default.nullOrUndefined(parsedPreset.tag)) {
            deps.push({
                depName: parsedPreset.repo,
                skipReason: 'unspecified-version',
            });
            continue;
        }
        deps.push({
            depName: parsedPreset.repo,
            datasource,
            currentValue: parsedPreset.tag,
        });
    }
    return is_1.default.nonEmptyArray(deps) ? { deps } : null;
}
//# sourceMappingURL=extract.js.map