"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.extractPackageFile = void 0;
const git_tags_1 = require("../../datasource/git-tags");
const github_tags_1 = require("../../datasource/github-tags");
const puppet_forge_1 = require("../../datasource/puppet-forge");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.url = 'https://www.puppet.com/docs/index.html';
exports.categories = ['iac', 'ruby'];
exports.defaultConfig = {
    managerFilePatterns: ['/(^|/)Puppetfile$/'],
};
exports.supportedDatasources = [
    puppet_forge_1.PuppetForgeDatasource.id,
    github_tags_1.GithubTagsDatasource.id,
    git_tags_1.GitTagsDatasource.id,
];
//# sourceMappingURL=index.js.map