"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RE_REPOSITORY_GENERIC_GIT_SSH_FORMAT = void 0;
exports.parseGitOwnerRepo = parseGitOwnerRepo;
exports.isGithubUrl = isGithubUrl;
const regex_1 = require("../../../util/regex");
const url_1 = require("../../../util/url");
exports.RE_REPOSITORY_GENERIC_GIT_SSH_FORMAT = (0, regex_1.regEx)(/^git@[^:]*:(?<repository>.+)$/);
function parseGitOwnerRepo(git, githubUrl) {
    const genericGitSsh = exports.RE_REPOSITORY_GENERIC_GIT_SSH_FORMAT.exec(git);
    if (genericGitSsh?.groups) {
        return genericGitSsh.groups.repository.replace((0, regex_1.regEx)(/\.git$/), '');
    }
    else {
        if (githubUrl) {
            return git
                .replace((0, regex_1.regEx)(/^github:/), '')
                .replace((0, regex_1.regEx)(/^git\+/), '')
                .replace((0, regex_1.regEx)(/^https:\/\/github\.com\//), '')
                .replace((0, regex_1.regEx)(/\.git$/), '');
        }
        const url = (0, url_1.parseUrl)(git);
        if (!url) {
            return null;
        }
        return url.pathname.replace((0, regex_1.regEx)(/\.git$/), '').replace((0, regex_1.regEx)(/^\//), '');
    }
}
function isGithubUrl(gitUrl, parsedUrl) {
    return (parsedUrl?.host === 'github.com' || gitUrl.startsWith('git@github.com'));
}
//# sourceMappingURL=common.js.map