"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PubspecLockYaml = exports.PubspecLockSchema = exports.PubspecYaml = exports.PubspecSchema = void 0;
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
const PubspecDependencySchema = (0, schema_utils_1.LooseRecord)(zod_1.z.string(), zod_1.z.union([
    zod_1.z.string(),
    zod_1.z.object({
        version: zod_1.z.string().optional(),
        path: zod_1.z.string().optional(),
        hosted: zod_1.z.union([
            zod_1.z.string().optional(),
            zod_1.z.object({ name: zod_1.z.string().optional(), url: zod_1.z.string().optional() }),
        ]),
    }),
]));
exports.PubspecSchema = zod_1.z.object({
    environment: zod_1.z.object({ sdk: zod_1.z.string(), flutter: zod_1.z.string().optional() }),
    dependencies: PubspecDependencySchema.optional(),
    dev_dependencies: PubspecDependencySchema.optional(),
});
exports.PubspecYaml = schema_utils_1.Yaml.pipe(exports.PubspecSchema);
exports.PubspecLockSchema = zod_1.z.object({
    sdks: zod_1.z.object({
        dart: zod_1.z.string(),
        flutter: zod_1.z.string().optional(),
    }),
});
exports.PubspecLockYaml = schema_utils_1.Yaml.pipe(exports.PubspecLockSchema);
//# sourceMappingURL=schema.js.map