"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.url = exports.displayName = exports.extractPackageFile = void 0;
const env_1 = require("../../../util/env");
const github_tags_1 = require("../../datasource/github-tags");
const gitlab_tags_1 = require("../../datasource/gitlab-tags");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
exports.displayName = 'pre-commit';
exports.url = 'https://pre-commit.com';
exports.defaultConfig = {
    commitMessageTopic: 'pre-commit hook {{depName}}',
    enabled: false,
    managerFilePatterns: ['/(^|/)\\.pre-commit-config\\.ya?ml$/'],
    prBodyNotes: (0, env_1.getEnv)().RENOVATE_X_SUPPRESS_PRE_COMMIT_WARNING
        ? /* istanbul ignore next */
            []
        : [
            'Note: The `pre-commit` manager in Renovate is not supported by the `pre-commit` maintainers or community. Please do not report any problems there, instead [create a Discussion in the Renovate repository](https://github.com/renovatebot/renovate/discussions/new) if you have any questions.',
        ],
};
exports.supportedDatasources = [
    github_tags_1.GithubTagsDatasource.id,
    gitlab_tags_1.GitlabTagsDatasource.id,
];
//# sourceMappingURL=index.js.map