import { z } from 'zod';
import type { PackageDependency, PackageFileContent } from '../types';
export declare const PoetryDependencies: z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, PackageDependency<Record<string, any>>>, Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>;
export declare const PoetryGroupDependencies: z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, PackageDependency<Record<string, any>>[]>, Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>;
export declare const PoetrySource: z.ZodObject<{
    name: z.ZodString;
    url: z.ZodOptional<z.ZodString>;
    priority: z.ZodDefault<z.ZodEnum<["default", "primary", "secondary", "supplemental", "explicit"]>>;
}, "strip", z.ZodTypeAny, {
    name: string;
    priority: "default" | "explicit" | "primary" | "secondary" | "supplemental";
    url?: string | undefined;
}, {
    name: string;
    url?: string | undefined;
    priority?: "default" | "explicit" | "primary" | "secondary" | "supplemental" | undefined;
}>;
export type PoetrySource = z.infer<typeof PoetrySource>;
export declare const PoetrySources: z.ZodCatch<z.ZodEffects<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
    name: string;
    priority: "default" | "explicit" | "primary" | "secondary" | "supplemental";
    url?: string | undefined;
}[], any[]>, {
    name: string;
    priority: "default" | "explicit" | "primary" | "secondary" | "supplemental";
    url?: string | undefined;
}[], any[]>>;
export declare const PoetrySectionSchema: z.ZodEffects<z.ZodObject<{
    version: z.ZodCatch<z.ZodOptional<z.ZodString>>;
    dependencies: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, PackageDependency<Record<string, any>>>, Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>>;
    'dev-dependencies': z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, PackageDependency<Record<string, any>>>, Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>>;
    group: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, PackageDependency<Record<string, any>>[]>, Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>>;
    source: z.ZodCatch<z.ZodEffects<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        name: string;
        priority: "default" | "explicit" | "primary" | "secondary" | "supplemental";
        url?: string | undefined;
    }[], any[]>, {
        name: string;
        priority: "default" | "explicit" | "primary" | "secondary" | "supplemental";
        url?: string | undefined;
    }[], any[]>>;
}, "strip", z.ZodTypeAny, {
    source: {
        name: string;
        priority: "default" | "explicit" | "primary" | "secondary" | "supplemental";
        url?: string | undefined;
    }[];
    version?: string | undefined;
    dependencies?: PackageDependency<Record<string, any>>[] | undefined;
    group?: PackageDependency<Record<string, any>>[] | undefined;
    'dev-dependencies'?: PackageDependency<Record<string, any>>[] | undefined;
}, {
    version?: unknown;
    source?: unknown;
    dependencies?: Record<string, any> | undefined;
    group?: Record<string, any> | undefined;
    'dev-dependencies'?: Record<string, any> | undefined;
}>, PackageFileContent<Record<string, any>>, {
    version?: unknown;
    source?: unknown;
    dependencies?: Record<string, any> | undefined;
    group?: Record<string, any> | undefined;
    'dev-dependencies'?: Record<string, any> | undefined;
}>;
export type PoetrySectionSchema = z.infer<typeof PoetrySectionSchema>;
export declare const PoetrySchema: z.ZodEffects<z.ZodObject<{
    tool: z.ZodEffects<z.ZodObject<{
        poetry: z.ZodEffects<z.ZodObject<{
            version: z.ZodCatch<z.ZodOptional<z.ZodString>>;
            dependencies: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, PackageDependency<Record<string, any>>>, Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>>;
            'dev-dependencies': z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, PackageDependency<Record<string, any>>>, Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>>;
            group: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, PackageDependency<Record<string, any>>[]>, Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>>;
            source: z.ZodCatch<z.ZodEffects<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                name: string;
                priority: "default" | "explicit" | "primary" | "secondary" | "supplemental";
                url?: string | undefined;
            }[], any[]>, {
                name: string;
                priority: "default" | "explicit" | "primary" | "secondary" | "supplemental";
                url?: string | undefined;
            }[], any[]>>;
        }, "strip", z.ZodTypeAny, {
            source: {
                name: string;
                priority: "default" | "explicit" | "primary" | "secondary" | "supplemental";
                url?: string | undefined;
            }[];
            version?: string | undefined;
            dependencies?: PackageDependency<Record<string, any>>[] | undefined;
            group?: PackageDependency<Record<string, any>>[] | undefined;
            'dev-dependencies'?: PackageDependency<Record<string, any>>[] | undefined;
        }, {
            version?: unknown;
            source?: unknown;
            dependencies?: Record<string, any> | undefined;
            group?: Record<string, any> | undefined;
            'dev-dependencies'?: Record<string, any> | undefined;
        }>, PackageFileContent<Record<string, any>>, {
            version?: unknown;
            source?: unknown;
            dependencies?: Record<string, any> | undefined;
            group?: Record<string, any> | undefined;
            'dev-dependencies'?: Record<string, any> | undefined;
        }>;
    }, "strip", z.ZodTypeAny, {
        poetry: PackageFileContent<Record<string, any>>;
    }, {
        poetry: {
            version?: unknown;
            source?: unknown;
            dependencies?: Record<string, any> | undefined;
            group?: Record<string, any> | undefined;
            'dev-dependencies'?: Record<string, any> | undefined;
        };
    }>, PackageFileContent<Record<string, any>>, {
        poetry: {
            version?: unknown;
            source?: unknown;
            dependencies?: Record<string, any> | undefined;
            group?: Record<string, any> | undefined;
            'dev-dependencies'?: Record<string, any> | undefined;
        };
    }>;
    'build-system': z.ZodCatch<z.ZodOptional<z.ZodEffects<z.ZodObject<{
        'build-backend': z.ZodEffects<z.ZodString, "poetry.masonry.api" | "poetry.core.masonry.api", string>;
        requires: z.ZodEffects<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            depName: string;
            poetryRequirement: string;
        }[], any[]>, string | undefined, any[]>;
    }, "strip", z.ZodTypeAny, {
        'build-backend': "poetry.masonry.api" | "poetry.core.masonry.api";
        requires?: string | undefined;
    }, {
        requires: any[];
        'build-backend': string;
    }>, string | undefined, {
        requires: any[];
        'build-backend': string;
    }>>>;
}, "strip", z.ZodTypeAny, {
    tool: PackageFileContent<Record<string, any>>;
    'build-system'?: string | undefined;
}, {
    tool: {
        poetry: {
            version?: unknown;
            source?: unknown;
            dependencies?: Record<string, any> | undefined;
            group?: Record<string, any> | undefined;
            'dev-dependencies'?: Record<string, any> | undefined;
        };
    };
    'build-system'?: unknown;
}>, {
    packageFileContent: PackageFileContent<Record<string, any>>;
    poetryRequirement: string | undefined;
}, {
    tool: {
        poetry: {
            version?: unknown;
            source?: unknown;
            dependencies?: Record<string, any> | undefined;
            group?: Record<string, any> | undefined;
            'dev-dependencies'?: Record<string, any> | undefined;
        };
    };
    'build-system'?: unknown;
}>;
export type PoetrySchema = z.infer<typeof PoetrySchema>;
export declare const PoetrySchemaToml: z.ZodPipeline<z.ZodEffects<z.ZodString, unknown, string>, z.ZodEffects<z.ZodObject<{
    tool: z.ZodEffects<z.ZodObject<{
        poetry: z.ZodEffects<z.ZodObject<{
            version: z.ZodCatch<z.ZodOptional<z.ZodString>>;
            dependencies: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, PackageDependency<Record<string, any>>>, Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>>;
            'dev-dependencies': z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, PackageDependency<Record<string, any>>>, Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>>;
            group: z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, PackageDependency<Record<string, any>>[]>, Record<string, any>>, PackageDependency<Record<string, any>>[], Record<string, any>>>;
            source: z.ZodCatch<z.ZodEffects<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
                name: string;
                priority: "default" | "explicit" | "primary" | "secondary" | "supplemental";
                url?: string | undefined;
            }[], any[]>, {
                name: string;
                priority: "default" | "explicit" | "primary" | "secondary" | "supplemental";
                url?: string | undefined;
            }[], any[]>>;
        }, "strip", z.ZodTypeAny, {
            source: {
                name: string;
                priority: "default" | "explicit" | "primary" | "secondary" | "supplemental";
                url?: string | undefined;
            }[];
            version?: string | undefined;
            dependencies?: PackageDependency<Record<string, any>>[] | undefined;
            group?: PackageDependency<Record<string, any>>[] | undefined;
            'dev-dependencies'?: PackageDependency<Record<string, any>>[] | undefined;
        }, {
            version?: unknown;
            source?: unknown;
            dependencies?: Record<string, any> | undefined;
            group?: Record<string, any> | undefined;
            'dev-dependencies'?: Record<string, any> | undefined;
        }>, PackageFileContent<Record<string, any>>, {
            version?: unknown;
            source?: unknown;
            dependencies?: Record<string, any> | undefined;
            group?: Record<string, any> | undefined;
            'dev-dependencies'?: Record<string, any> | undefined;
        }>;
    }, "strip", z.ZodTypeAny, {
        poetry: PackageFileContent<Record<string, any>>;
    }, {
        poetry: {
            version?: unknown;
            source?: unknown;
            dependencies?: Record<string, any> | undefined;
            group?: Record<string, any> | undefined;
            'dev-dependencies'?: Record<string, any> | undefined;
        };
    }>, PackageFileContent<Record<string, any>>, {
        poetry: {
            version?: unknown;
            source?: unknown;
            dependencies?: Record<string, any> | undefined;
            group?: Record<string, any> | undefined;
            'dev-dependencies'?: Record<string, any> | undefined;
        };
    }>;
    'build-system': z.ZodCatch<z.ZodOptional<z.ZodEffects<z.ZodObject<{
        'build-backend': z.ZodEffects<z.ZodString, "poetry.masonry.api" | "poetry.core.masonry.api", string>;
        requires: z.ZodEffects<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
            depName: string;
            poetryRequirement: string;
        }[], any[]>, string | undefined, any[]>;
    }, "strip", z.ZodTypeAny, {
        'build-backend': "poetry.masonry.api" | "poetry.core.masonry.api";
        requires?: string | undefined;
    }, {
        requires: any[];
        'build-backend': string;
    }>, string | undefined, {
        requires: any[];
        'build-backend': string;
    }>>>;
}, "strip", z.ZodTypeAny, {
    tool: PackageFileContent<Record<string, any>>;
    'build-system'?: string | undefined;
}, {
    tool: {
        poetry: {
            version?: unknown;
            source?: unknown;
            dependencies?: Record<string, any> | undefined;
            group?: Record<string, any> | undefined;
            'dev-dependencies'?: Record<string, any> | undefined;
        };
    };
    'build-system'?: unknown;
}>, {
    packageFileContent: PackageFileContent<Record<string, any>>;
    poetryRequirement: string | undefined;
}, {
    tool: {
        poetry: {
            version?: unknown;
            source?: unknown;
            dependencies?: Record<string, any> | undefined;
            group?: Record<string, any> | undefined;
            'dev-dependencies'?: Record<string, any> | undefined;
        };
    };
    'build-system'?: unknown;
}>>;
export declare const Lockfile: z.ZodEffects<z.ZodPipeline<z.ZodEffects<z.ZodString, unknown, string>, z.ZodObject<{
    package: z.ZodCatch<z.ZodEffects<z.ZodEffects<z.ZodArray<z.ZodAny, "many">, [string, string][], any[]>, {
        [k: string]: string;
    }, any[]>>;
    metadata: z.ZodCatch<z.ZodEffects<z.ZodObject<{
        'lock-version': z.ZodCatch<z.ZodOptional<z.ZodEffects<z.ZodString, string, string>>>;
        'python-versions': z.ZodCatch<z.ZodOptional<z.ZodString>>;
    }, "strip", z.ZodTypeAny, {
        'lock-version'?: string | undefined;
        'python-versions'?: string | undefined;
    }, {
        'lock-version'?: unknown;
        'python-versions'?: unknown;
    }>, {
        poetryConstraint: string | undefined;
        pythonVersions: string | undefined;
    }, {
        'lock-version'?: unknown;
        'python-versions'?: unknown;
    }>>;
}, "strip", z.ZodTypeAny, {
    metadata: {
        poetryConstraint: string | undefined;
        pythonVersions: string | undefined;
    };
    package: {
        [k: string]: string;
    };
}, {
    metadata?: unknown;
    package?: unknown;
}>>, {
    lock: {
        [k: string]: string;
    };
    poetryConstraint: string | undefined;
    pythonVersions: string | undefined;
}, string>;
