"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.supportsLockFileMaintenance = exports.updateArtifacts = exports.extractPackageFile = void 0;
const conda_1 = require("../../datasource/conda");
const pypi_1 = require("../../datasource/pypi");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
var artifacts_1 = require("./artifacts");
Object.defineProperty(exports, "updateArtifacts", { enumerable: true, get: function () { return artifacts_1.updateArtifacts; } });
exports.supportsLockFileMaintenance = true;
exports.url = 'https://github.com/prefix-dev/pixi/';
exports.categories = ['python'];
exports.defaultConfig = {
    managerFilePatterns: [
        '/(^|/)pyproject\\.toml$/', // `tool.pixi` section
        '/(^|/)pixi\\.toml$/', // root object
    ],
};
exports.supportedDatasources = [pypi_1.PypiDatasource.id, conda_1.CondaDatasource.id];
//# sourceMappingURL=index.js.map