"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.supportedDatasources = exports.defaultConfig = exports.categories = exports.url = exports.displayName = exports.supportsLockFileMaintenance = exports.updateArtifacts = exports.extractPackageFile = exports.extractAllPackageFiles = void 0;
const git_tags_1 = require("../../datasource/git-tags");
const pypi_1 = require("../../datasource/pypi");
var extract_1 = require("./extract");
Object.defineProperty(exports, "extractAllPackageFiles", { enumerable: true, get: function () { return extract_1.extractAllPackageFiles; } });
Object.defineProperty(exports, "extractPackageFile", { enumerable: true, get: function () { return extract_1.extractPackageFile; } });
var artifacts_1 = require("./artifacts");
Object.defineProperty(exports, "updateArtifacts", { enumerable: true, get: function () { return artifacts_1.updateArtifacts; } });
exports.supportsLockFileMaintenance = true;
exports.displayName = 'pip-compile';
exports.url = 'https://pip-tools.readthedocs.io/en/latest/cli/pip-compile';
exports.categories = ['python'];
exports.defaultConfig = {
    managerFilePatterns: [],
    lockFileMaintenance: {
        enabled: true,
        branchTopic: 'pip-compile-refresh',
        commitMessageAction: 'Refresh pip-compile outputs',
    },
};
exports.supportedDatasources = [pypi_1.PypiDatasource.id, git_tags_1.GitTagsDatasource.id];
//# sourceMappingURL=index.js.map