"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Pep723Schema = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const zod_1 = require("zod");
const schema_utils_1 = require("../../../util/schema-utils");
const utils_1 = require("../pep621/utils");
const Pep723Dep = zod_1.z
    .string()
    .transform((dep) => (0, utils_1.pep508ToPackageDependency)(utils_1.depTypes.dependencies, dep));
exports.Pep723Schema = schema_utils_1.Toml.pipe(zod_1.z
    .object({
    'requires-python': zod_1.z.string().optional(),
    dependencies: zod_1.z
        .array(Pep723Dep)
        .transform((deps) => deps.filter((dep) => !!dep))
        .optional(),
})
    .transform(({ 'requires-python': requiresPython, dependencies }) => {
    const res = { deps: dependencies ?? [] };
    if (is_1.default.nonEmptyString(requiresPython)) {
        res.extractedConstraints = { python: requiresPython };
    }
    return res;
}));
//# sourceMappingURL=schema.js.map