import { z } from 'zod';
export type PyProject = z.infer<typeof PyProjectSchema>;
declare const UvGitSource: z.ZodObject<{
    git: z.ZodString;
    rev: z.ZodOptional<z.ZodString>;
    tag: z.ZodOptional<z.ZodString>;
    branch: z.ZodOptional<z.ZodString>;
}, "strip", z.ZodTypeAny, {
    git: string;
    branch?: string | undefined;
    rev?: string | undefined;
    tag?: string | undefined;
}, {
    git: string;
    branch?: string | undefined;
    rev?: string | undefined;
    tag?: string | undefined;
}>;
export type UvGitSource = z.infer<typeof UvGitSource>;
export declare const PyProjectSchema: z.ZodObject<{
    project: z.ZodOptional<z.ZodObject<{
        version: z.ZodCatch<z.ZodOptional<z.ZodString>>;
        'requires-python': z.ZodOptional<z.ZodString>;
        dependencies: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        'optional-dependencies': z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodArray<z.ZodString, "many">>>;
    }, "strip", z.ZodTypeAny, {
        version?: string | undefined;
        dependencies?: string[] | undefined;
        'requires-python'?: string | undefined;
        'optional-dependencies'?: Record<string, string[]> | undefined;
    }, {
        version?: unknown;
        dependencies?: string[] | undefined;
        'requires-python'?: string | undefined;
        'optional-dependencies'?: Record<string, string[]> | undefined;
    }>>;
    'build-system': z.ZodOptional<z.ZodObject<{
        requires: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
        'build-backend': z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        requires?: string[] | undefined;
        'build-backend'?: string | undefined;
    }, {
        requires?: string[] | undefined;
        'build-backend'?: string | undefined;
    }>>;
    'dependency-groups': z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodEffects<z.ZodArray<z.ZodAny, "many">, string[], any[]>>>;
    tool: z.ZodOptional<z.ZodObject<{
        pixi: z.ZodOptional<z.ZodIntersection<z.ZodIntersection<z.ZodUnion<[z.ZodEffects<z.ZodObject<{
            workspace: z.ZodObject<{
                channels: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodObject<{
                    channel: z.ZodString;
                    priority: z.ZodNumber;
                }, "strip", z.ZodTypeAny, {
                    priority: number;
                    channel: string;
                }, {
                    priority: number;
                    channel: string;
                }>]>, "many">>;
                'requires-pixi': z.ZodOptional<z.ZodString>;
                'channel-priority': z.ZodDefault<z.ZodUnion<[z.ZodLiteral<"strict">, z.ZodLiteral<"disabled">]>>;
            }, "strip", z.ZodTypeAny, {
                channels: (string | {
                    priority: number;
                    channel: string;
                })[];
                'channel-priority': "disabled" | "strict";
                'requires-pixi'?: string | undefined;
            }, {
                channels?: (string | {
                    priority: number;
                    channel: string;
                })[] | undefined;
                'requires-pixi'?: string | undefined;
                'channel-priority'?: "disabled" | "strict" | undefined;
            }>;
        }, "strip", z.ZodTypeAny, {
            workspace: {
                channels: (string | {
                    priority: number;
                    channel: string;
                })[];
                'channel-priority': "disabled" | "strict";
                'requires-pixi'?: string | undefined;
            };
        }, {
            workspace: {
                channels?: (string | {
                    priority: number;
                    channel: string;
                })[] | undefined;
                'requires-pixi'?: string | undefined;
                'channel-priority'?: "disabled" | "strict" | undefined;
            };
        }>, {
            project: {
                channels: (string | {
                    priority: number;
                    channel: string;
                })[];
                'channel-priority': "disabled" | "strict";
                'requires-pixi'?: string | undefined;
            };
        }, {
            workspace: {
                channels?: (string | {
                    priority: number;
                    channel: string;
                })[] | undefined;
                'requires-pixi'?: string | undefined;
                'channel-priority'?: "disabled" | "strict" | undefined;
            };
        }>, z.ZodObject<{
            project: z.ZodObject<{
                channels: z.ZodDefault<z.ZodArray<z.ZodUnion<[z.ZodString, z.ZodObject<{
                    channel: z.ZodString;
                    priority: z.ZodNumber;
                }, "strip", z.ZodTypeAny, {
                    priority: number;
                    channel: string;
                }, {
                    priority: number;
                    channel: string;
                }>]>, "many">>;
                'requires-pixi': z.ZodOptional<z.ZodString>;
                'channel-priority': z.ZodDefault<z.ZodUnion<[z.ZodLiteral<"strict">, z.ZodLiteral<"disabled">]>>;
            }, "strip", z.ZodTypeAny, {
                channels: (string | {
                    priority: number;
                    channel: string;
                })[];
                'channel-priority': "disabled" | "strict";
                'requires-pixi'?: string | undefined;
            }, {
                channels?: (string | {
                    priority: number;
                    channel: string;
                })[] | undefined;
                'requires-pixi'?: string | undefined;
                'channel-priority'?: "disabled" | "strict" | undefined;
            }>;
        }, "strip", z.ZodTypeAny, {
            project: {
                channels: (string | {
                    priority: number;
                    channel: string;
                })[];
                'channel-priority': "disabled" | "strict";
                'requires-pixi'?: string | undefined;
            };
        }, {
            project: {
                channels?: (string | {
                    priority: number;
                    channel: string;
                })[] | undefined;
                'requires-pixi'?: string | undefined;
                'channel-priority'?: "disabled" | "strict" | undefined;
            };
        }>]>, z.ZodObject<{
            feature: z.ZodDefault<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
                channels?: (string | {
                    priority: number;
                    channel: string;
                })[] | undefined;
            } & {
                pypi: import("../pixi/schema").PixiPackageDependency[];
                conda: import("../pixi/schema").PixiPackageDependency[];
            }>, Record<string, any>>, {
                conda: import("../pixi/schema").PixiPackageDependency[];
                pypi: import("../pixi/schema").PixiPackageDependency[];
            }, Record<string, any>>>;
        }, "strip", z.ZodTypeAny, {
            feature: {
                conda: import("../pixi/schema").PixiPackageDependency[];
                pypi: import("../pixi/schema").PixiPackageDependency[];
            };
        }, {
            feature?: Record<string, any> | undefined;
        }>>, z.ZodEffects<z.ZodObject<{
            dependencies: z.ZodDefault<z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
                currentValue: string;
                versioning: string;
                datasource: string;
                channel: string | undefined;
            }>, Record<string, any>>, import("../types").PackageDependency<Record<string, any>>[], Record<string, any>>>>;
            'pypi-dependencies': z.ZodDefault<z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
                currentValue: string;
                versioning: string;
                datasource: string;
            } | {
                currentValue: string | undefined;
                packageName: string;
                datasource: string;
                versioning: string;
                skipStage: "extract";
                skipReason: "unspecified-version";
            } | {
                currentValue: string;
                packageName: string;
                datasource: string;
                versioning: string;
                skipStage?: undefined;
                skipReason?: undefined;
            }>, Record<string, any>>, import("../types").PackageDependency<Record<string, any>>[], Record<string, any>>>>;
            target: z.ZodDefault<z.ZodOptional<z.ZodEffects<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
                dependencies: import("../types").PackageDependency<Record<string, any>>[];
                'pypi-dependencies': import("../types").PackageDependency<Record<string, any>>[];
            }>, Record<string, any>>, {
                pypi: import("../pixi/schema").PixiPackageDependency[];
                conda: import("../pixi/schema").PixiPackageDependency[];
            }, Record<string, any>>>>;
        }, "strip", z.ZodTypeAny, {
            target: {
                pypi: import("../pixi/schema").PixiPackageDependency[];
                conda: import("../pixi/schema").PixiPackageDependency[];
            };
            dependencies: import("../types").PackageDependency<Record<string, any>>[];
            'pypi-dependencies': import("../types").PackageDependency<Record<string, any>>[];
        }, {
            target?: Record<string, any> | undefined;
            dependencies?: Record<string, any> | undefined;
            'pypi-dependencies'?: Record<string, any> | undefined;
        }>, {
            pypi: import("../pixi/schema").PixiPackageDependency[];
            conda: import("../pixi/schema").PixiPackageDependency[];
        }, {
            target?: Record<string, any> | undefined;
            dependencies?: Record<string, any> | undefined;
            'pypi-dependencies'?: Record<string, any> | undefined;
        }>>>;
        pdm: z.ZodOptional<z.ZodObject<{
            'dev-dependencies': z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodArray<z.ZodString, "many">>>;
            source: z.ZodOptional<z.ZodArray<z.ZodObject<{
                url: z.ZodString;
                name: z.ZodString;
                verify_ssl: z.ZodOptional<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                url: string;
                name: string;
                verify_ssl?: boolean | undefined;
            }, {
                url: string;
                name: string;
                verify_ssl?: boolean | undefined;
            }>, "many">>;
        }, "strip", z.ZodTypeAny, {
            source?: {
                url: string;
                name: string;
                verify_ssl?: boolean | undefined;
            }[] | undefined;
            'dev-dependencies'?: Record<string, string[]> | undefined;
        }, {
            source?: {
                url: string;
                name: string;
                verify_ssl?: boolean | undefined;
            }[] | undefined;
            'dev-dependencies'?: Record<string, string[]> | undefined;
        }>>;
        hatch: z.ZodOptional<z.ZodObject<{
            envs: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodOptional<z.ZodObject<{
                dependencies: z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
                'extra-dependencies': z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            }, "strip", z.ZodTypeAny, {
                dependencies?: string[] | undefined;
                'extra-dependencies'?: string[] | undefined;
            }, {
                dependencies?: string[] | undefined;
                'extra-dependencies'?: string[] | undefined;
            }>>>>;
        }, "strip", z.ZodTypeAny, {
            envs?: Record<string, {
                dependencies?: string[] | undefined;
                'extra-dependencies'?: string[] | undefined;
            } | undefined> | undefined;
        }, {
            envs?: Record<string, {
                dependencies?: string[] | undefined;
                'extra-dependencies'?: string[] | undefined;
            } | undefined> | undefined;
        }>>;
        uv: z.ZodOptional<z.ZodObject<{
            'dev-dependencies': z.ZodOptional<z.ZodArray<z.ZodString, "many">>;
            'required-version': z.ZodOptional<z.ZodString>;
            sources: z.ZodOptional<z.ZodEffects<z.ZodRecord<z.ZodString, z.ZodAny>, Record<string, {
                index: string;
            } | {
                git: string;
                branch?: string | undefined;
                rev?: string | undefined;
                tag?: string | undefined;
            } | {
                url: string;
            } | {
                path: string;
            } | {
                workspace: true;
            }>, Record<string, any>>>;
            index: z.ZodOptional<z.ZodArray<z.ZodObject<{
                name: z.ZodOptional<z.ZodString>;
                url: z.ZodString;
                default: z.ZodDefault<z.ZodBoolean>;
                explicit: z.ZodDefault<z.ZodBoolean>;
            }, "strip", z.ZodTypeAny, {
                default: boolean;
                url: string;
                explicit: boolean;
                name?: string | undefined;
            }, {
                url: string;
                default?: boolean | undefined;
                name?: string | undefined;
                explicit?: boolean | undefined;
            }>, "many">>;
        }, "strip", z.ZodTypeAny, {
            sources?: Record<string, {
                index: string;
            } | {
                git: string;
                branch?: string | undefined;
                rev?: string | undefined;
                tag?: string | undefined;
            } | {
                url: string;
            } | {
                path: string;
            } | {
                workspace: true;
            }> | undefined;
            'dev-dependencies'?: string[] | undefined;
            index?: {
                default: boolean;
                url: string;
                explicit: boolean;
                name?: string | undefined;
            }[] | undefined;
            'required-version'?: string | undefined;
        }, {
            sources?: Record<string, any> | undefined;
            'dev-dependencies'?: string[] | undefined;
            index?: {
                url: string;
                default?: boolean | undefined;
                name?: string | undefined;
                explicit?: boolean | undefined;
            }[] | undefined;
            'required-version'?: string | undefined;
        }>>;
    }, "strip", z.ZodTypeAny, {
        pixi?: ((({
            project: {
                channels: (string | {
                    priority: number;
                    channel: string;
                })[];
                'channel-priority': "disabled" | "strict";
                'requires-pixi'?: string | undefined;
            };
        } | {
            project: {
                channels: (string | {
                    priority: number;
                    channel: string;
                })[];
                'channel-priority': "disabled" | "strict";
                'requires-pixi'?: string | undefined;
            };
        }) & {
            feature: {
                conda: import("../pixi/schema").PixiPackageDependency[];
                pypi: import("../pixi/schema").PixiPackageDependency[];
            };
        }) & {
            pypi: import("../pixi/schema").PixiPackageDependency[];
            conda: import("../pixi/schema").PixiPackageDependency[];
        }) | undefined;
        uv?: {
            sources?: Record<string, {
                index: string;
            } | {
                git: string;
                branch?: string | undefined;
                rev?: string | undefined;
                tag?: string | undefined;
            } | {
                url: string;
            } | {
                path: string;
            } | {
                workspace: true;
            }> | undefined;
            'dev-dependencies'?: string[] | undefined;
            index?: {
                default: boolean;
                url: string;
                explicit: boolean;
                name?: string | undefined;
            }[] | undefined;
            'required-version'?: string | undefined;
        } | undefined;
        pdm?: {
            source?: {
                url: string;
                name: string;
                verify_ssl?: boolean | undefined;
            }[] | undefined;
            'dev-dependencies'?: Record<string, string[]> | undefined;
        } | undefined;
        hatch?: {
            envs?: Record<string, {
                dependencies?: string[] | undefined;
                'extra-dependencies'?: string[] | undefined;
            } | undefined> | undefined;
        } | undefined;
    }, {
        pixi?: ((({
            workspace: {
                channels?: (string | {
                    priority: number;
                    channel: string;
                })[] | undefined;
                'requires-pixi'?: string | undefined;
                'channel-priority'?: "disabled" | "strict" | undefined;
            };
        } | {
            project: {
                channels?: (string | {
                    priority: number;
                    channel: string;
                })[] | undefined;
                'requires-pixi'?: string | undefined;
                'channel-priority'?: "disabled" | "strict" | undefined;
            };
        }) & {
            feature?: Record<string, any> | undefined;
        }) & {
            target?: Record<string, any> | undefined;
            dependencies?: Record<string, any> | undefined;
            'pypi-dependencies'?: Record<string, any> | undefined;
        }) | undefined;
        uv?: {
            sources?: Record<string, any> | undefined;
            'dev-dependencies'?: string[] | undefined;
            index?: {
                url: string;
                default?: boolean | undefined;
                name?: string | undefined;
                explicit?: boolean | undefined;
            }[] | undefined;
            'required-version'?: string | undefined;
        } | undefined;
        pdm?: {
            source?: {
                url: string;
                name: string;
                verify_ssl?: boolean | undefined;
            }[] | undefined;
            'dev-dependencies'?: Record<string, string[]> | undefined;
        } | undefined;
        hatch?: {
            envs?: Record<string, {
                dependencies?: string[] | undefined;
                'extra-dependencies'?: string[] | undefined;
            } | undefined> | undefined;
        } | undefined;
    }>>;
}, "strip", z.ZodTypeAny, {
    project?: {
        version?: string | undefined;
        dependencies?: string[] | undefined;
        'requires-python'?: string | undefined;
        'optional-dependencies'?: Record<string, string[]> | undefined;
    } | undefined;
    tool?: {
        pixi?: ((({
            project: {
                channels: (string | {
                    priority: number;
                    channel: string;
                })[];
                'channel-priority': "disabled" | "strict";
                'requires-pixi'?: string | undefined;
            };
        } | {
            project: {
                channels: (string | {
                    priority: number;
                    channel: string;
                })[];
                'channel-priority': "disabled" | "strict";
                'requires-pixi'?: string | undefined;
            };
        }) & {
            feature: {
                conda: import("../pixi/schema").PixiPackageDependency[];
                pypi: import("../pixi/schema").PixiPackageDependency[];
            };
        }) & {
            pypi: import("../pixi/schema").PixiPackageDependency[];
            conda: import("../pixi/schema").PixiPackageDependency[];
        }) | undefined;
        uv?: {
            sources?: Record<string, {
                index: string;
            } | {
                git: string;
                branch?: string | undefined;
                rev?: string | undefined;
                tag?: string | undefined;
            } | {
                url: string;
            } | {
                path: string;
            } | {
                workspace: true;
            }> | undefined;
            'dev-dependencies'?: string[] | undefined;
            index?: {
                default: boolean;
                url: string;
                explicit: boolean;
                name?: string | undefined;
            }[] | undefined;
            'required-version'?: string | undefined;
        } | undefined;
        pdm?: {
            source?: {
                url: string;
                name: string;
                verify_ssl?: boolean | undefined;
            }[] | undefined;
            'dev-dependencies'?: Record<string, string[]> | undefined;
        } | undefined;
        hatch?: {
            envs?: Record<string, {
                dependencies?: string[] | undefined;
                'extra-dependencies'?: string[] | undefined;
            } | undefined> | undefined;
        } | undefined;
    } | undefined;
    'build-system'?: {
        requires?: string[] | undefined;
        'build-backend'?: string | undefined;
    } | undefined;
    'dependency-groups'?: Record<string, string[]> | undefined;
}, {
    project?: {
        version?: unknown;
        dependencies?: string[] | undefined;
        'requires-python'?: string | undefined;
        'optional-dependencies'?: Record<string, string[]> | undefined;
    } | undefined;
    tool?: {
        pixi?: ((({
            workspace: {
                channels?: (string | {
                    priority: number;
                    channel: string;
                })[] | undefined;
                'requires-pixi'?: string | undefined;
                'channel-priority'?: "disabled" | "strict" | undefined;
            };
        } | {
            project: {
                channels?: (string | {
                    priority: number;
                    channel: string;
                })[] | undefined;
                'requires-pixi'?: string | undefined;
                'channel-priority'?: "disabled" | "strict" | undefined;
            };
        }) & {
            feature?: Record<string, any> | undefined;
        }) & {
            target?: Record<string, any> | undefined;
            dependencies?: Record<string, any> | undefined;
            'pypi-dependencies'?: Record<string, any> | undefined;
        }) | undefined;
        uv?: {
            sources?: Record<string, any> | undefined;
            'dev-dependencies'?: string[] | undefined;
            index?: {
                url: string;
                default?: boolean | undefined;
                name?: string | undefined;
                explicit?: boolean | undefined;
            }[] | undefined;
            'required-version'?: string | undefined;
        } | undefined;
        pdm?: {
            source?: {
                url: string;
                name: string;
                verify_ssl?: boolean | undefined;
            }[] | undefined;
            'dev-dependencies'?: Record<string, string[]> | undefined;
        } | undefined;
        hatch?: {
            envs?: Record<string, {
                dependencies?: string[] | undefined;
                'extra-dependencies'?: string[] | undefined;
            } | undefined> | undefined;
        } | undefined;
    } | undefined;
    'build-system'?: {
        requires?: string[] | undefined;
        'build-backend'?: string | undefined;
    } | undefined;
    'dependency-groups'?: Record<string, any[]> | undefined;
}>;
export declare const PdmLockfileSchema: z.ZodEffects<z.ZodEffects<z.ZodPipeline<z.ZodEffects<z.ZodString, unknown, string>, z.ZodObject<{
    package: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        name: string;
        version: string;
    }[], any[]>;
}, "strip", z.ZodTypeAny, {
    package: {
        name: string;
        version: string;
    }[];
}, {
    package: any[];
}>>, {
    [k: string]: string;
}, string>, {
    lock: {
        [k: string]: string;
    };
}, string>;
export declare const UvLockfileSchema: z.ZodEffects<z.ZodPipeline<z.ZodEffects<z.ZodString, unknown, string>, z.ZodObject<{
    package: z.ZodEffects<z.ZodArray<z.ZodAny, "many">, {
        name: string;
        version: string;
    }[], any[]>;
}, "strip", z.ZodTypeAny, {
    package: {
        name: string;
        version: string;
    }[];
}, {
    package: any[];
}>>, {
    [k: string]: string;
}, string>;
export {};
