"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HatchProcessor = void 0;
const tslib_1 = require("tslib");
const is_1 = tslib_1.__importDefault(require("@sindresorhus/is"));
const utils_1 = require("../utils");
class HatchProcessor {
    process(pyproject, deps) {
        const hatch_envs = pyproject.tool?.hatch?.envs;
        if (is_1.default.nullOrUndefined(hatch_envs)) {
            return deps;
        }
        for (const [envName, env] of Object.entries(hatch_envs)) {
            const depType = `tool.hatch.envs.${envName}`;
            const envDeps = (0, utils_1.parseDependencyList)(depType, env?.dependencies);
            deps.push(...envDeps);
            const extraDeps = (0, utils_1.parseDependencyList)(depType, env?.['extra-dependencies']);
            deps.push(...extraDeps);
        }
        return deps;
    }
    extractLockedVersions(project, deps, packageFile) {
        return Promise.resolve(deps);
    }
    updateArtifacts(updateArtifact, project) {
        // Hatch does not have lock files at the moment
        // https://github.com/pypa/hatch/issues/749
        return Promise.resolve(null);
    }
}
exports.HatchProcessor = HatchProcessor;
//# sourceMappingURL=hatch.js.map