"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bumpPackageVersion = bumpPackageVersion;
const semver_1 = require("semver");
const logger_1 = require("../../../logger");
const regex_1 = require("../../../util/regex");
function bumpPackageVersion(content, currentValue, bumpVersion) {
    logger_1.logger.debug({ bumpVersion, currentValue }, 'Checking if we should bump OCB version');
    let bumpedContent = content;
    try {
        const newProjectVersion = (0, semver_1.inc)(currentValue, bumpVersion);
        if (!newProjectVersion) {
            throw new Error('semver inc failed');
        }
        logger_1.logger.debug(`newProjectVersion: ${newProjectVersion}`);
        bumpedContent = content.replace((0, regex_1.regEx)(/\b(?<version>version:\s+["']?)(?<currentValue>[^'"\s]*)/), `$<version>${newProjectVersion}`);
        if (bumpedContent === content) {
            logger_1.logger.debug('Version was already bumped');
        }
        else {
            logger_1.logger.debug('Bumped OCB version');
        }
    }
    catch {
        logger_1.logger.warn({
            content,
            currentValue,
            bumpVersion,
            manager: 'ocb',
        }, 'Failed to bumpVersion');
    }
    return { bumpedContent };
}
//# sourceMappingURL=update.js.map