"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.bumpPackageVersion = bumpPackageVersion;
const tslib_1 = require("tslib");
const semver_1 = tslib_1.__importDefault(require("semver"));
const xmldoc_1 = require("xmldoc");
const logger_1 = require("../../../logger");
const string_1 = require("../../../util/string");
const util_1 = require("./util");
function bumpPackageVersion(content, currentValue, bumpVersion) {
    logger_1.logger.debug({ bumpVersion, currentValue }, 'Checking if we should bump project version');
    let bumpedContent = content;
    if (!semver_1.default.valid(currentValue)) {
        logger_1.logger.warn({ currentValue }, 'Unable to bump project version, not a valid semver');
        return { bumpedContent };
    }
    try {
        const project = new xmldoc_1.XmlDocument(content);
        const versionNode = (0, util_1.findVersion)(project);
        if (!versionNode) {
            logger_1.logger.warn("Couldn't find Version or VersionPrefix in any PropertyGroup");
            return { bumpedContent };
        }
        const currentProjVersion = versionNode.val;
        if (currentProjVersion !== currentValue) {
            logger_1.logger.warn({ currentValue, currentProjVersion }, "currentValue passed to bumpPackageVersion() doesn't match value found");
            return { bumpedContent };
        }
        const startTagPosition = versionNode.startTagPosition; // TODO: should not be null
        const versionPosition = content.indexOf(currentProjVersion, startTagPosition);
        const newProjVersion = semver_1.default.inc(currentValue, bumpVersion);
        if (!newProjVersion) {
            throw new Error('semver inc failed');
        }
        logger_1.logger.debug(`newProjVersion: ${newProjVersion}`);
        bumpedContent = (0, string_1.replaceAt)(content, versionPosition, currentValue, newProjVersion);
    }
    catch {
        logger_1.logger.warn({
            content,
            currentValue,
            bumpVersion,
        }, 'Failed to bumpVersion');
    }
    return { bumpedContent };
}
//# sourceMappingURL=update.js.map